/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.upgrade;

import java.io.InputStream;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeUtils {
    private static final Log log = ExoLogger.getLogger(UpgradeUtils.class);

    public static void registerNodeTypes(String nodeTypeFilesName, int alreadyExistsBehaviour) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ConfigurationManager configurationService = (ConfigurationManager)container.getComponentInstanceOfType(ConfigurationManager.class);
        InputStream isXml = configurationService.getInputStream(nodeTypeFilesName);
        KSDataLocation dataLocation = (KSDataLocation)container.getComponentInstance(KSDataLocation.class);
        ExtendedNodeTypeManager ntManager = dataLocation.getRepositoryService().getCurrentRepository().getNodeTypeManager();
        log.info((Object)("\nTrying register node types from xml-file " + nodeTypeFilesName));
        ntManager.registerNodeTypes(isXml, alreadyExistsBehaviour, "text/xml");
        log.info((Object)("\nNode types were registered from xml-file " + nodeTypeFilesName));
    }
}

