/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationLogoutListener
extends Listener<ConversationRegistry, ConversationState> {
    protected static Log log = ExoLogger.getLogger(AuthenticationLogoutListener.class);

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        block3: {
            try {
                MailService mService = (MailService)PortalContainer.getInstance().getComponentInstanceOfType(MailService.class);
                String username = ((ConversationState)event.getData()).getIdentity().getUserId();
                List<Account> accList = mService.getAccounts(username);
                for (Account acc : accList) {
                    mService.stopAllJobs(username, acc.getId());
                }
                mService.closeAllMailConnectionByUser(username);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Exception when stop stop all job when user logout", (Throwable)e);
            }
        }
    }
}

