/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.hibernate;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.type.Type;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.util.EqualsHelper;
import org.hibernate.util.StringHelper;

public class SybaseTextType
implements EnhancedUserType,
Serializable {
    private transient Log log;
    private static final boolean IS_VALUE_TRACING_ENABLED = LogFactory.getLog((String)StringHelper.qualifier((String)Type.class.getName())).isTraceEnabled();
    private static final long serialVersionUID = 1L;

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog(this.getClass());
        }
        return this.log;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached != null ? this.deepCopy(cached) : null;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return value != null ? (Serializable)this.deepCopy(value) : null;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return EqualsHelper.equals((Object)x, (Object)y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, names[0]);
    }

    public Object nullSafeGet(ResultSet rs, String name) throws HibernateException, SQLException {
        try {
            Object value = this.get(rs, name);
            if (value == null) {
                if (IS_VALUE_TRACING_ENABLED) {
                    this.log().trace((Object)("returning null as column: " + name));
                }
                return null;
            }
            if (IS_VALUE_TRACING_ENABLED) {
                this.log().trace((Object)("returning '" + this.toString(value) + "' as column: " + name));
            }
            return value;
        }
        catch (RuntimeException re) {
            this.log().info((Object)("could not read column value from result set: " + name + "; " + re.getMessage()));
            throw re;
        }
        catch (SQLException se) {
            this.log().info((Object)("could not read column value from result set: " + name + "; " + se.getMessage()));
            throw se;
        }
    }

    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        Reader charReader = rs.getCharacterStream(name);
        if (charReader == null || rs.wasNull()) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        try {
            int amountRead;
            char[] cbuf = new char[1024];
            while ((amountRead = charReader.read(cbuf)) != -1) {
                sbuf.append(cbuf, 0, amountRead);
            }
        }
        catch (IOException ioe) {
            throw new HibernateException("IOException occurred reading text", (Throwable)ioe);
        }
        finally {
            try {
                charReader.close();
            }
            catch (IOException e) {
                throw new HibernateException("IOException occurred closing stream", (Throwable)e);
            }
        }
        return sbuf.toString();
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        try {
            if (value == null) {
                if (IS_VALUE_TRACING_ENABLED) {
                    this.log().trace((Object)("binding null to parameter: " + index));
                }
                this.setNull(st, index);
            } else {
                if (IS_VALUE_TRACING_ENABLED) {
                    this.log().trace((Object)("binding '" + this.toString(value) + "' to parameter: " + index));
                }
                this.set(st, value, index);
            }
        }
        catch (RuntimeException re) {
            this.log().info((Object)("could not bind value '" + this.nullSafeToString(value) + "' to parameter: " + index + "; " + re.getMessage()));
            throw re;
        }
        catch (SQLException se) {
            this.log().info((Object)("could not bind value '" + this.nullSafeToString(value) + "' to parameter: " + index + "; " + se.getMessage()));
            throw se;
        }
    }

    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        String str = (String)value;
        st.setCharacterStream(index, (Reader)new StringReader(str), str.length());
    }

    public void setNull(PreparedStatement st, int index) throws HibernateException, SQLException {
        st.setCharacterStream(index, (Reader)null, 0);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class returnedClass() {
        return String.class;
    }

    public int[] sqlTypes() {
        return new int[]{this.sqlType()};
    }

    public int sqlType() {
        return 2005;
    }

    public String objectToSQLString(Object value) {
        return '\'' + (String)value + '\'';
    }

    public Object fromXMLString(String xml) {
        return xml != null && xml.length() > 0 ? this.fromStringValue(xml) : null;
    }

    public String toXMLString(Object value) {
        return this.toString(value);
    }

    public String nullSafeToString(Object value) throws HibernateException {
        return value != null ? this.toString(value) : null;
    }

    public String toString(Object value) {
        return (String)value;
    }

    public Object fromStringValue(String xml) {
        return xml;
    }
}

