/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Retransmitter;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.TimeScheduler;

public class RetransmitterTest
extends TestCase {
    private final Address sender = new IpAddress(5555);
    Retransmitter xmitter;
    TimeScheduler timer = new TimeScheduler();

    protected void setUp() throws Exception {
        super.setUp();
        this.xmitter = new Retransmitter(this.sender, new MyXmitter(), this.timer);
        this.xmitter.setRetransmitTimeouts(new StaticInterval(1000L, 2000L, 4000L, 8000L));
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{RetransmitterTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void testNoEntry() {
        int size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)0, (int)size);
    }

    public void testSingleEntry() {
        this.xmitter.add(1L, 1L);
        int size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)1, (int)size);
    }

    public void testEntry() {
        this.xmitter.add(1L, 10L);
        int size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)10, (int)size);
    }

    public void testMultipleEntries() {
        this.xmitter.add(1L, 10L);
        int size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)10, (int)size);
        this.xmitter.add(12L, 13L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)12, (int)size);
        this.xmitter.remove(5L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)11, (int)size);
        this.xmitter.remove(13L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)10, (int)size);
        this.xmitter.remove(1L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)9, (int)size);
        this.xmitter.remove(13L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)9, (int)size);
        this.xmitter.remove(12L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)8, (int)size);
        for (int i = 8; i >= 0; --i) {
            this.xmitter.remove(i);
        }
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)2, (int)size);
        this.xmitter.remove(10L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)1, (int)size);
        this.xmitter.remove(9L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        RetransmitterTest.assertEquals((int)0, (int)size);
    }

    static class MyXmitter
    implements Retransmitter.RetransmitCommand {
        MyXmitter() {
        }

        @Override
        public void retransmit(long first_seqno, long last_seqno, Address sender) {
        }
    }
}

