/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.xml;

import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;

public class MembershipXMLEntity
implements StreamingOutput {
    private static final Log log = ExoLogger.getExoLogger(MembershipXMLEntity.class);
    private final Membership membership_;
    private final String baseURI_;

    public MembershipXMLEntity(Membership membership, String baseURI) {
        this.membership_ = membership;
        this.baseURI_ = baseURI;
    }

    public void write(OutputStream out) throws IOException {
        try {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            XMLStreamWriter xsw = outputFactory.createXMLStreamWriter(out);
            xsw.writeStartDocument();
            xsw.writeStartElement("membership");
            xsw.writeDefaultNamespace("http://exoplatform.org/organization/rest");
            xsw.writeNamespace("xlink", "http://www.w3.org/1999/xlink");
            xsw.writeAttribute("http://www.w3.org/1999/xlink", "href", this.baseURI_ + "/organization/membership/" + this.membership_.getId() + "/?output=xml&command=view");
            xsw.writeStartElement("id");
            xsw.writeCharacters(this.membership_.getId());
            xsw.writeEndElement();
            xsw.writeStartElement("group-id");
            xsw.writeCharacters(this.membership_.getGroupId());
            xsw.writeEndElement();
            xsw.writeStartElement("user-name");
            xsw.writeCharacters(this.membership_.getUserName());
            xsw.writeEndElement();
            xsw.writeStartElement("membership-type");
            xsw.writeCharacters(this.membership_.getMembershipType());
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception in method write", (Throwable)e);
            }
            throw new IOException(e.getMessage());
        }
    }
}

