/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.Util;
import com.install4j.api.context.FileOptions;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.FileOptionsConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.config.MacSpecificConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.config.UnixSpecificConfig;
import com.install4j.runtime.installer.config.WindowsSpecificConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nanoxml.XMLElement;

public class InstallerConfig
extends AbstractConfig {
    private static InstallerConfig currentConfig = null;
    private String type;
    private String applicationName = "";
    private String applicationVersion = "";
    private String defaultInstallationDirectory = "";
    private boolean jreShared = false;
    private String jreVersion = "";
    private List installerScreenConfigs = Collections.EMPTY_LIST;
    private List uninstallerScreenConfigs = Collections.EMPTY_LIST;
    private List components = Collections.EMPTY_LIST;
    private ComponentFolderConfig componentRoot = new ComponentFolderConfig(null);
    private List launchers = Collections.EMPTY_LIST;
    private List uninstallDeleteEntries;
    private String minJavaVersion = "";
    private String publisherName = "";
    private String publisherURL = "";
    private String mediaName = "";
    private boolean allowUnattended = false;
    private boolean allowConsole = false;
    private File installationDirectory;
    private String downloadURL = "";
    private List customJars = Collections.EMPTY_LIST;
    private int windowWidth = 500;
    private int windowHeight = 390;
    private boolean watermark = true;
    private boolean resizable = true;
    private String status = "";
    private List languages = Collections.EMPTY_LIST;
    private boolean skipLanguageSelection = false;
    private Map compilerVariables = Collections.EMPTY_MAP;
    private Map externalRoots = Collections.EMPTY_MAP;
    private String applicationId = "";
    private int installerType;
    private boolean suggestPreviousProgramGroup = false;
    private String addonAppId = "";
    private boolean suggestPreviousLocations = true;
    private boolean lzmaCompression = false;
    private boolean pack200Compression = false;
    private FileOptionsConfig fileOptionsConfig = new FileOptionsConfig();
    private WindowsSpecificConfig windowsSpecificConfig = new WindowsSpecificConfig();
    private MacSpecificConfig macSpecificConfig = new MacSpecificConfig();
    private UnixSpecificConfig unixSpecificConfig = new UnixSpecificConfig();
    private boolean readGeneralOnly;

    public static InstallerConfig getCurrentInstance() {
        if (currentConfig == null) {
            try {
                currentConfig = new InstallerConfig(InstallerUtil.getInstallerFile("i4jparams.conf"), false);
            }
            catch (IOException iOException) {
                GUIHelper.showMessage(null, "Internal error: Could not open config file.", 0);
                System.exit(1);
            }
        }
        return currentConfig;
    }

    public static InstallerConfig getGeneralConfigFromFile(File file) throws IOException {
        return new InstallerConfig(file, true);
    }

    private InstallerConfig(File file, boolean bl) throws IOException {
        this.readGeneralOnly = bl;
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseFromReader(inputStreamReader);
        this.read(xMLElement);
        inputStreamReader.close();
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public boolean isWatermark() {
        return this.watermark;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public String getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public boolean isAllowUnattended() {
        return this.allowUnattended;
    }

    public boolean isLzmaCompression() {
        return this.lzmaCompression;
    }

    public String getType() {
        return this.type;
    }

    public boolean isJreShared() {
        return this.jreShared;
    }

    public String getJreVersion() {
        return this.jreVersion;
    }

    public String getApplicationName() {
        return InstallerVariables.replaceVariables(this.applicationName);
    }

    public String getApplicationNameWithVersion() {
        String string = this.getApplicationName();
        if (this.getApplicationVersion().trim().length() > 0 && this.getApplicationName().indexOf(this.getApplicationVersion()) == -1) {
            string = string + " " + this.getApplicationVersion();
        }
        return string;
    }

    public File getInstallationDirectory() {
        if (this.installationDirectory == null) {
            this.installationDirectory = this.getInitialInstallationDirectory();
        }
        return this.installationDirectory;
    }

    public void setInstallationDirectory(File file) {
        this.installationDirectory = file;
    }

    private File getInitialInstallationDirectory() {
        int n;
        int n2;
        String string;
        String string2;
        if (this.isSuggestPreviousLocations() && (string2 = InstallRegistry.getInstallationDir(string = this.getTargetApplicationId())) != null && string2.trim().length() > 0) {
            String string3 = InstallRegistry.getSingleBundleName(string, string2);
            if (Util.isMacosInstaller() && this.getInstallerType() == 2 && string3 != null) {
                return new File(string2, string3 + "/" + "Contents/Resources/app");
            }
            if (new File(string2).getParentFile() != null) {
                return new File(string2);
            }
        }
        if ((string = this.defaultInstallationDirectory).startsWith("~")) {
            string = System.getProperty("user.home") + string.substring(1);
        }
        while ((n2 = string.indexOf(123)) > -1 && (n = string.indexOf(125, n2)) >= 0) {
            String string4 = string.substring(n2, n + 1);
            string = string.substring(0, n2) + InstallerConfig.getVariableValue(string4) + string.substring(n + 1);
        }
        return new File(string);
    }

    private static String getVariableValue(String string) {
        if (string.equals("{/}")) {
            return File.separator;
        }
        if (string.equals("{appdir}")) {
            return InstallerUtil.getStandardApplicationsDirectory();
        }
        return "";
    }

    public List getInstallerScreenConfigs() {
        return this.installerScreenConfigs;
    }

    public List getUninstallerScreenConfigs() {
        return this.uninstallerScreenConfigs;
    }

    public String getPublisherName() {
        return InstallerVariables.replaceVariables(this.publisherName);
    }

    public String getPublisherURL() {
        return InstallerVariables.replaceVariables(this.publisherURL);
    }

    public String getDownloadURL() {
        return InstallerVariables.replaceVariables(this.downloadURL);
    }

    public String getStatus() {
        return this.status;
    }

    public List getComponents() {
        return this.components;
    }

    public ComponentConfig getComponentById(String string) {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            ComponentConfig componentConfig = (ComponentConfig)iterator.next();
            if (!componentConfig.getId().equals(string)) continue;
            return componentConfig;
        }
        return null;
    }

    public ComponentFolderConfig getComponentRoot() {
        return this.componentRoot;
    }

    public List getLaunchers() {
        return this.launchers;
    }

    public LauncherConfig getLauncherConfigById(String string) {
        Iterator iterator = this.launchers.iterator();
        while (iterator.hasNext()) {
            LauncherConfig launcherConfig = (LauncherConfig)iterator.next();
            if (!launcherConfig.getId().equals(string)) continue;
            return launcherConfig;
        }
        return null;
    }

    public List getServices() {
        ArrayList<LauncherConfig> arrayList = new ArrayList<LauncherConfig>();
        Iterator iterator = this.launchers.iterator();
        while (iterator.hasNext()) {
            LauncherConfig launcherConfig = (LauncherConfig)iterator.next();
            if (!(launcherConfig instanceof ServiceConfig)) continue;
            arrayList.add(launcherConfig);
        }
        return arrayList;
    }

    public ServiceConfig getServiceConfigById(String string) {
        LauncherConfig launcherConfig = this.getLauncherConfigById(string);
        if (launcherConfig != null && launcherConfig instanceof ServiceConfig) {
            return (ServiceConfig)launcherConfig;
        }
        return null;
    }

    public List getUninstallDeleteEntries() {
        return this.uninstallDeleteEntries;
    }

    public FileOptions getOptions(String string) {
        return this.fileOptionsConfig.getOptions(string);
    }

    public FileOptionsConfig getFileOptionsConfig() {
        return this.fileOptionsConfig;
    }

    public WindowsSpecificConfig getWindowsSpecificConfig() {
        return this.windowsSpecificConfig;
    }

    public MacSpecificConfig getMacSpecificConfig() {
        return this.macSpecificConfig;
    }

    public UnixSpecificConfig getUnixSpecificConfig() {
        return this.unixSpecificConfig;
    }

    public List getLanguages() {
        return this.languages;
    }

    public boolean isSkipLanguageSelection() {
        return this.skipLanguageSelection;
    }

    public LanguageConfig getLanguageById(String string) {
        Iterator iterator = this.languages.iterator();
        while (iterator.hasNext()) {
            LanguageConfig languageConfig = (LanguageConfig)iterator.next();
            if (!languageConfig.getId().equals(string)) continue;
            return languageConfig;
        }
        return null;
    }

    public Map getCompilerVariables() {
        return this.compilerVariables;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public int getInstallerType() {
        return this.installerType;
    }

    public boolean isSuggestPreviousProgramGroup() {
        return this.suggestPreviousProgramGroup;
    }

    public String getAddonAppId() {
        return this.addonAppId;
    }

    public boolean isSuggestPreviousLocations() {
        return this.suggestPreviousLocations;
    }

    public boolean isPack200Compression() {
        return this.pack200Compression;
    }

    public List getCustomJars() {
        return this.customJars;
    }

    protected void read(XMLElement xMLElement) {
        this.type = InstallerConfig.readAttribute(xMLElement, "type", this.type);
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = xMLElement2.getName();
            if (string.equals("general")) {
                this.readGeneral(xMLElement2);
            }
            if (this.readGeneralOnly) continue;
            if (string.equals("languages")) {
                this.readLanguages(xMLElement2);
                continue;
            }
            if (string.equals("variables")) {
                this.readVariables(xMLElement2);
                continue;
            }
            if (string.equals("externalRoots")) {
                this.readRoots(xMLElement2);
                continue;
            }
            if (string.equals("customCode")) {
                this.readCustomCode(xMLElement2);
                continue;
            }
            if (string.equals("installerScreens")) {
                this.readInstallerScreens(xMLElement2);
                continue;
            }
            if (string.equals("uninstallerScreens")) {
                this.readUninstallerScreens(xMLElement2);
                continue;
            }
            if (string.equals("fileOptions")) {
                this.fileOptionsConfig.read(xMLElement2);
                continue;
            }
            if (string.equals("components")) {
                this.readComponents(xMLElement2);
                continue;
            }
            if (string.equals("launchers")) {
                this.readLaunchers(xMLElement2);
                continue;
            }
            if (string.equals("uninstallDelete")) {
                this.readUninstallDelete(xMLElement2);
                continue;
            }
            if (string.equals("windowsSpecific")) {
                this.windowsSpecificConfig.read(xMLElement2);
                continue;
            }
            if (string.equals("macSpecific")) {
                this.macSpecificConfig.read(xMLElement2);
                continue;
            }
            if (!string.equals("unixSpecific")) continue;
            this.unixSpecificConfig.read(xMLElement2);
        }
    }

    private void readCustomCode(XMLElement xMLElement) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = InstallerConfig.readAttribute(xMLElement2, "name", null);
            if (string == null) continue;
            linkedList.add(string);
        }
        this.customJars = Collections.unmodifiableList(linkedList);
    }

    private void readGeneral(XMLElement xMLElement) {
        this.applicationName = InstallerConfig.readAttribute(xMLElement, "applicationName", this.applicationName);
        this.defaultInstallationDirectory = InstallerConfig.readAttribute(xMLElement, "defaultInstallationDirectory", this.defaultInstallationDirectory);
        this.status = InstallerConfig.readAttribute(xMLElement, "status", this.status);
        this.jreShared = InstallerConfig.readAttribute(xMLElement, "jreShared", this.jreShared);
        this.jreVersion = InstallerConfig.readAttribute(xMLElement, "jreVersion", this.jreVersion);
        this.minJavaVersion = InstallerConfig.readAttribute(xMLElement, "minJavaVersion", this.minJavaVersion);
        this.windowWidth = InstallerConfig.readAttribute(xMLElement, "windowWidth", this.windowWidth);
        this.windowHeight = InstallerConfig.readAttribute(xMLElement, "windowHeight", this.windowHeight);
        this.watermark = InstallerConfig.readAttribute(xMLElement, "watermark", this.watermark);
        this.resizable = InstallerConfig.readAttribute(xMLElement, "resizable", this.resizable);
        this.publisherName = InstallerConfig.readAttribute(xMLElement, "publisherName", this.publisherName);
        this.publisherURL = InstallerConfig.readAttribute(xMLElement, "publisherURL", this.publisherURL);
        this.mediaName = InstallerConfig.readAttribute(xMLElement, "mediaName", this.mediaName);
        this.allowUnattended = InstallerConfig.readAttribute(xMLElement, "allowUnattended", this.allowUnattended);
        this.allowConsole = InstallerConfig.readAttribute(xMLElement, "allowConsole", this.allowConsole);
        this.applicationVersion = InstallerConfig.readAttribute(xMLElement, "applicationVersion", this.applicationVersion);
        this.lzmaCompression = InstallerConfig.readAttribute(xMLElement, "lzmaCompression", this.lzmaCompression);
        this.pack200Compression = InstallerConfig.readAttribute(xMLElement, "pack200Compression", this.pack200Compression);
        this.downloadURL = InstallerConfig.readAttribute(xMLElement, "downloadURL", this.downloadURL);
        this.applicationId = InstallerConfig.readAttribute(xMLElement, "applicationId", this.applicationId);
        this.installerType = InstallerConfig.readAttribute(xMLElement, "installerType", this.installerType);
        this.suggestPreviousProgramGroup = InstallerConfig.readAttribute(xMLElement, "suggestPreviousProgramGroup", this.suggestPreviousProgramGroup);
        this.addonAppId = InstallerConfig.readAttribute(xMLElement, "addOnAppId", this.addonAppId);
        this.suggestPreviousLocations = InstallerConfig.readAttribute(xMLElement, "suggestPreviousLocations", this.suggestPreviousLocations);
    }

    private void readLanguages(XMLElement xMLElement) {
        this.skipLanguageSelection = InstallerConfig.readAttribute(xMLElement, "skipLanguageSelection", this.skipLanguageSelection);
        LinkedList<LanguageConfig> linkedList = new LinkedList<LanguageConfig>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            LanguageConfig languageConfig = new LanguageConfig();
            languageConfig.read(xMLElement2);
            linkedList.add(languageConfig);
        }
        this.languages = Collections.unmodifiableList(linkedList);
    }

    private void readVariables(XMLElement xMLElement) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = InstallerConfig.readAttribute(xMLElement2, "name", null);
            String string2 = InstallerConfig.readAttribute(xMLElement2, "value", null);
            if (string == null || string2 == null) continue;
            hashMap.put(string, string2);
        }
        this.compilerVariables = Collections.unmodifiableMap(hashMap);
    }

    private void readRoots(XMLElement xMLElement) {
        this.externalRoots = new HashMap();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = InstallerConfig.readAttribute(xMLElement2, "id", null);
            String string2 = InstallerConfig.readAttribute(xMLElement2, "location", null);
            if (string == null || string2 == null) continue;
            this.externalRoots.put(string, string2);
        }
    }

    private void readInstallerScreens(XMLElement xMLElement) {
        this.installerScreenConfigs = Collections.unmodifiableList(this.readScreenConfigs(xMLElement));
    }

    private void readUninstallerScreens(XMLElement xMLElement) {
        this.uninstallerScreenConfigs = Collections.unmodifiableList(this.readScreenConfigs(xMLElement));
    }

    private List readScreenConfigs(XMLElement xMLElement) {
        LinkedList<ScreenBeanConfig> linkedList = new LinkedList<ScreenBeanConfig>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            ScreenBeanConfig screenBeanConfig = new ScreenBeanConfig();
            screenBeanConfig.read(xMLElement2);
            linkedList.add(screenBeanConfig);
        }
        return linkedList;
    }

    private void readUninstallDelete(XMLElement xMLElement) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = InstallerConfig.readAttribute(xMLElement2, "name", "");
            if (string.equals("")) continue;
            arrayList.add(string);
        }
        this.uninstallDeleteEntries = Collections.unmodifiableList(arrayList);
    }

    private void readComponents(XMLElement xMLElement) {
        LinkedList linkedList = new LinkedList();
        this.componentRoot.read(xMLElement);
        this.collectComponents(this.componentRoot.getComponents(), linkedList);
        this.components = Collections.unmodifiableList(linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ComponentConfig componentConfig = (ComponentConfig)iterator.next();
            componentConfig.notifyDependentComponents(this);
        }
    }

    private void collectComponents(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ComponentNodeConfig componentNodeConfig = (ComponentNodeConfig)iterator.next();
            if (componentNodeConfig instanceof ComponentConfig) {
                list2.add(componentNodeConfig);
                continue;
            }
            if (!(componentNodeConfig instanceof ComponentFolderConfig)) continue;
            this.collectComponents(((ComponentFolderConfig)componentNodeConfig).getComponents(), list2);
        }
    }

    private void readLaunchers(XMLElement xMLElement) {
        LinkedList<LauncherConfig> linkedList = new LinkedList<LauncherConfig>();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            LauncherConfig launcherConfig;
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = xMLElement2.getName();
            if (string.equals("launcher")) {
                launcherConfig = new LauncherConfig();
            } else {
                if (!string.equals("service")) continue;
                launcherConfig = new ServiceConfig();
            }
            launcherConfig.read(xMLElement2);
            linkedList.add(launcherConfig);
        }
        this.launchers = Collections.unmodifiableList(linkedList);
    }

    public String getTargetApplicationId() {
        if (this.getInstallerType() == 1) {
            return this.getApplicationId();
        }
        return this.getAddonAppId();
    }

    public String getRootById(String string) {
        return (String)this.externalRoots.get(string);
    }

    public boolean isAllowConsole() {
        return this.allowConsole;
    }
}

