/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy.codeassistant;

import groovyjarjarantlr.RecognitionException;
import groovyjarjarantlr.TokenStreamException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyMethodDoc;
import org.codehaus.groovy.groovydoc.GroovyParameter;
import org.codehaus.groovy.groovydoc.GroovyRootDoc;
import org.exoplatform.ide.groovy.JcrUtils;
import org.exoplatform.ide.groovy.codeassistant.FileFinder;
import org.exoplatform.ide.groovy.codeassistant.SaveDocException;
import org.exoplatform.ide.groovy.codeassistant.bean.JarEntry;
import org.exoplatform.ide.groovy.codeassistant.extractors.DocExtractor;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Path(value="/ide/doc-storage")
public class DocStorage {
    private final RepositoryService repositoryService;
    private final ThreadLocalSessionProviderService sessionProviderService;
    private final String wsName;
    private static final Log LOG = ExoLogger.getLogger(DocStorage.class);

    public DocStorage(String wsName, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, final List<JarEntry> jars, boolean runInThread) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.wsName = wsName;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    DocStorage.this.addJavaDocsOnStartUp(jars);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.runTask(run, runInThread);
    }

    private void runTask(Runnable run, boolean runInThread) {
        if (runInThread) {
            new Thread(run, "DocStorage").start();
        } else {
            run.run();
        }
    }

    private void addJavaDocsOnStartUp(List<JarEntry> jars) throws SaveDocException {
        try {
            SessionProvider sp = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sp.getSession(this.wsName, JcrUtils.getRepository(this.repositoryService));
            for (JarEntry entry : jars) {
                String path = entry.getJarPath();
                FileFinder fileFinder = new FileFinder(path);
                for (String jarFile : fileFinder.getFileList()) {
                    try {
                        LOG.info((Object)("Load JavaDoc from jar - " + jarFile));
                        if (entry.getIncludePkgs() == null || entry.getIncludePkgs().isEmpty()) {
                            Map<String, GroovyRootDoc> roots = DocExtractor.extract(jarFile);
                            Set<String> keys = roots.keySet();
                            for (String key : keys) {
                                GroovyClassDoc[] docs;
                                for (GroovyClassDoc doc : docs = roots.get(key).classes()) {
                                    this.putDoc(session, doc, key + "." + doc.name());
                                }
                            }
                            continue;
                        }
                        for (String pkgs : entry.getIncludePkgs()) {
                            LOG.info((Object)("Load JavaDoc from - " + pkgs));
                            Map<String, GroovyRootDoc> roots = DocExtractor.extract(jarFile, pkgs);
                            Set<String> keys = roots.keySet();
                            for (String key : keys) {
                                GroovyClassDoc[] docs;
                                for (GroovyClassDoc doc : docs = roots.get(key).classes()) {
                                    this.putDoc(session, doc, key + "." + doc.name());
                                }
                            }
                        }
                    }
                    catch (RepositoryException e) {
                        LOG.warn((Object)e.getMessage());
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.warn((Object)e.getMessage());
                    }
                    catch (RecognitionException e) {
                        LOG.warn((Object)e.getMessage());
                    }
                    catch (TokenStreamException e) {
                        LOG.warn((Object)e.getMessage());
                    }
                    catch (IOException e) {
                        LOG.warn((Object)e.getMessage());
                    }
                }
            }
            session.save();
            session.logout();
            LOG.info((Object)"Load javadoc complete");
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveDocException(400, e.getMessage());
        }
        catch (RepositoryConfigurationException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveDocException(400, e.getMessage());
        }
    }

    @POST
    @Path(value="/jar-source")
    public void addDocs(@QueryParam(value="jar") String jar, @QueryParam(value="package") String packageName) throws SaveDocException {
        block12: {
            try {
                Session session = JcrUtils.getSession(this.repositoryService, this.sessionProviderService, this.wsName);
                Map<String, GroovyRootDoc> roots = DocExtractor.extract(jar, packageName);
                Set<String> keys = roots.keySet();
                for (String key : keys) {
                    GroovyClassDoc[] docs;
                    for (GroovyClassDoc doc : docs = roots.get(key).classes()) {
                        this.putDoc(session, doc, key + "." + doc.name());
                    }
                }
            }
            catch (RepositoryException e) {
                if (LOG.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new SaveDocException(400, e.getMessage());
            }
            catch (RepositoryConfigurationException e) {
                if (LOG.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new SaveDocException(400, e.getMessage());
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new SaveDocException(400, e.getMessage());
            }
            catch (RecognitionException e) {
                if (LOG.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            catch (TokenStreamException e) {
                if (!LOG.isDebugEnabled()) break block12;
                e.printStackTrace();
            }
        }
    }

    private void putDoc(Session session, GroovyClassDoc doc, String fqn) throws RepositoryException, UnsupportedEncodingException {
        if (!session.getRootNode().hasNode("dev-doc")) {
            Node node = session.getRootNode().addNode("dev-doc", "nt:folder");
        }
        Node base = session.getRootNode().getNode("dev-doc");
        String clazz = fqn;
        Node child = base;
        String[] seg = fqn.split("\\.");
        String path = new String();
        for (int i = 0; i < seg.length; ++i) {
            child = !child.hasNode(path = path + seg[i]) ? child.addNode(path, "nt:folder") : child.getNode(path);
            path = path + ".";
        }
        if (!child.hasNode(clazz)) {
            Node cls = child.addNode(clazz, "nt:file");
            Node content = cls.addNode("jcr:content", "exoide:classDoc");
            content.setProperty("jcr:data", doc.commentText());
            content.setProperty("jcr:lastModified", Calendar.getInstance());
            content.setProperty("jcr:mimeType", "text/plain");
            content.setProperty("exoide:fqn", clazz);
            this.putMethodDoc(cls.getParent(), doc, clazz);
        }
        session.save();
    }

    private void putMethodDoc(Node cls, GroovyClassDoc doc, String clsFqn) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException, UnsupportedEncodingException {
        Node methodsDoc = !cls.hasNode("methods-doc") ? cls.addNode("methods-doc", "nt:folder") : cls.getNode("methods-doc");
        GroovyMethodDoc[] docs = doc.methods();
        for (int i = 0; i < docs.length; ++i) {
            String methName = docs[i].name() + URLEncoder.encode(DocStorage.array2string(docs[i].parameters()), "UTF-8");
            if (methName.length() > 500) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"FQN of method are too long and will be skiped");
                }
                return;
            }
            if (!methodsDoc.hasNode(methName)) {
                Node method = methodsDoc.addNode(methName, "nt:file");
                Node content = method.addNode("jcr:content", "exoide:methodDoc");
                content.setProperty("jcr:data", docs[i].getRawCommentText());
                content.setProperty("jcr:lastModified", Calendar.getInstance());
                content.setProperty("jcr:mimeType", "text/plain");
                content.setProperty("exoide:fqn", clsFqn + "." + docs[i].name() + DocStorage.array2string(docs[i].parameters()));
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn((Object)"Tryed ad name with same name and parameters.");
        }
        cls.getSession().save();
    }

    private static String array2string(GroovyParameter[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "()";
        }
        StringBuilder b = new StringBuilder();
        b.append('(');
        int i = 0;
        while (true) {
            b.append(a[i].typeName());
            if (i == iMax) {
                return b.append(')').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public void addDocsFromSource(String pathToFile) throws SaveDocException {
    }
}

