/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoricalMessageImpl;
import org.jivesoftware.smack.packet.Message;

public class HistoryUtils {
    private static final String XMPP_DELAY_DATETIME_FORMAT = "yyyyMMdd'T'HH:mm:ss";

    public static HistoricalMessageImpl messageToHistoricalMessage(Message message) {
        HistoricalMessageImpl historicalMessage = new HistoricalMessageImpl();
        historicalMessage.setId(message.getPacketID());
        historicalMessage.setFrom(message.getFrom());
        historicalMessage.setTo(message.getTo());
        historicalMessage.setType(message.getType().name());
        historicalMessage.setBody(message.getBody());
        historicalMessage.setReceive(false);
        historicalMessage.setRepository(message.getProperty("repository").toString());
        Date delayedDate = HistoryUtils.getDelayedDate(message);
        if (delayedDate != null) {
            historicalMessage.setDateSend(new Date(delayedDate.getTime()));
        } else {
            historicalMessage.setDateSend(Calendar.getInstance().getTime());
        }
        return historicalMessage;
    }

    private static Date getDelayedDate(Message message) {
        Date delayedDate = null;
        SimpleDateFormat delayedFormatter = new SimpleDateFormat(XMPP_DELAY_DATETIME_FORMAT);
        try {
            String xmlns = message.getExtension("jabber:x:delay").toXML();
            Document document = DocumentHelper.parseText((String)xmlns);
            Element delayInformation = document.getRootElement();
            delayedDate = delayedFormatter.parse(delayInformation.attributeValue("stamp"));
        }
        catch (Exception e) {
            return null;
        }
        return delayedDate;
    }
}

