/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.migration;

import java.util.Collection;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.gatein.pc.api.PortletInvokerException;

public class PLF35HomesTool {
    private final PortalContainer container = PortalContainer.getInstance();
    private final OrganizationService service = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
    private final SpaceStorage spaceStorage = (SpaceStorage)this.container.getComponentInstanceOfType(SpaceStorage.class);
    private final String UI_SIMPLE_TEMPLATE = "system:/groovy/portal/webui/container/UIContainer.gtmpl";
    private final String UI_TABLE_COLUMN_TEMPLATE = "system:/groovy/portal/webui/container/UITableColumnContainer.gtmpl";
    private final String PORTLET_SUMMARY = "acme-intranet-portlet/SpaceSummaryInfoPortlet";
    private final String PORTLET_DETAILS = "presentation/SingleContentViewer";
    private static final Log LOG = ExoLogger.getLogger(PLF35HomesTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws PortletInvokerException {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            GroupHandler groupHandler = this.service.getGroupHandler();
            Group spaces = groupHandler.findGroupById("/spaces");
            Collection groups = groupHandler.findGroups(spaces);
            for (Group group : groups) {
                Query query = new Query("group", group.getId(), null, null, Page.class);
                DataStorage dataStorage = SpaceUtils.getDataStorage();
                List pages = dataStorage.find(query).getAll();
                for (Page page : pages) {
                    if (!"SpaceActivityStreamPortlet".equals(page.getName())) continue;
                    Container root = (Container)page.getChildren().get(0);
                    Container bottom = (Container)root.getChildren().get(1);
                    Application application = (Application)bottom.getChildren().get(0);
                    bottom.setTemplate("system:/groovy/portal/webui/container/UITableColumnContainer.gtmpl");
                    Container left = new Container();
                    left.setTemplate("system:/groovy/portal/webui/container/UIContainer.gtmpl");
                    left.setAccessPermissions(root.getAccessPermissions());
                    Space space = this.spaceStorage.getSpaceByGroupId(group.getId());
                    TransientApplicationState summaryState = new TransientApplicationState("acme-intranet-portlet/SpaceSummaryInfoPortlet");
                    Application summaryApplication = new Application(ApplicationType.PORTLET);
                    summaryApplication.getProperties().put((Object)"SPACE_URL", (Object)space.getUrl());
                    summaryApplication.setAccessPermissions(root.getAccessPermissions());
                    summaryApplication.setShowInfoBar(false);
                    summaryApplication.setState((ApplicationState)summaryState);
                    summaryApplication.setTitle("Space Summary Info");
                    TransientApplicationState detailsState = new TransientApplicationState("presentation/SingleContentViewer");
                    Application detailsApplication = new Application(ApplicationType.PORTLET);
                    detailsApplication.setAccessPermissions(root.getAccessPermissions());
                    detailsApplication.getProperties().put((Object)"repository", (Object)"repository");
                    detailsApplication.getProperties().put((Object)"workspace", (Object)"collaboration");
                    detailsApplication.getProperties().put((Object)"nodeIdentifier", (Object)"");
                    detailsApplication.getProperties().put((Object)"ShowQuickEdit", (Object)"true");
                    detailsApplication.getProperties().put((Object)"ShowPrintAction", (Object)"false");
                    detailsApplication.getProperties().put((Object)"ShowTitle", (Object)"false");
                    detailsApplication.setShowApplicationState(false);
                    detailsApplication.setShowApplicationMode(false);
                    detailsApplication.setShowInfoBar(false);
                    detailsApplication.setState((ApplicationState)detailsState);
                    detailsApplication.setTitle("Content Details");
                    left.getChildren().add(summaryApplication);
                    left.getChildren().add(detailsApplication);
                    bottom.getChildren().clear();
                    bottom.getChildren().add(left);
                    bottom.getChildren().add(application);
                    dataStorage.save(page);
                    LOG.info((Object)("Upgrade space home for : " + page.getTitle()));
                }
            }
        }
        catch (Exception e) {
            LOG.info((Object)("Error during template migration : " + e.getMessage()), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

