/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.netvibes.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.TreeMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.common.http.client.CookieModule;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.ParseException;
import org.exoplatform.ide.netvibes.util.NetvibesUtil;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

@Path(value="/ide/netvibes")
public class NetvibesWidgetService {
    private static String NETVIBES_URL = "http://api.eco.netvibes.com";
    private static String SUBMIT = "/submit/?";
    private final RepositoryService repositoryService;
    private final ThreadLocalSessionProviderService sessionProviderService;

    public NetvibesWidgetService(RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    @GET
    @Path(value="/{repoName}/{repoPath:.*}/")
    @Produces(value={"text/html"})
    public InputStream showContent(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath) {
        String wsName = repoPath.split("/")[0];
        String nodePath = repoPath.substring(repoPath.indexOf("/") + 1);
        InputStream inputStream = null;
        try {
            Session session = this.getSession(repoName, wsName);
            inputStream = NetvibesUtil.getContent(session, nodePath);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (RepositoryConfigurationException e) {
            e.printStackTrace();
        }
        return inputStream;
    }

    @POST
    @Path(value="/deploy")
    @Produces(value={"text/xml"})
    public String deployNetvibesWidget(String inputStream, @QueryParam(value="login") String login, @QueryParam(value="password") String password, @QueryParam(value="secretkey") String secretkey, @QueryParam(value="apikey") String apikey) {
        TreeMap<String, String> sign = new TreeMap<String, String>();
        sign.put("apikey", apikey);
        sign.put("content", inputStream);
        sign.put("secret", secretkey);
        ArrayList<String> tempSign = new ArrayList<String>();
        for (String key : sign.keySet()) {
            tempSign.add(key + "=" + (String)sign.get(key));
        }
        String signParametr = StringUtils.join(tempSign, (String)"&");
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            signParametr = NetvibesWidgetService.byteArray2Hex(md.digest(signParametr.getBytes()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new WebApplicationException((Throwable)noSuchAlgorithmException, this.createErrorResponse(noSuchAlgorithmException, 500));
        }
        try {
            URL url = new URL(NETVIBES_URL);
            NVPair[] headers = new NVPair[]{new NVPair("Content-Type", "application/atom+xml;type=entry")};
            HTTPConnection connection = new HTTPConnection(url);
            connection.removeModule(CookieModule.class);
            connection.setAllowUserInteraction(false);
            connection.addBasicAuthorization(null, login, password);
            HTTPResponse response = connection.Post(NETVIBES_URL + SUBMIT + "apikey=" + apikey + "&sign=" + signParametr, inputStream.getBytes(), headers);
            return response.getText();
        }
        catch (MalformedURLException malformedURLException) {
            throw new WebApplicationException((Throwable)malformedURLException, this.createErrorResponse(malformedURLException, 500));
        }
        catch (IOException ioException) {
            throw new WebApplicationException((Throwable)ioException, this.createErrorResponse(ioException, 500));
        }
        catch (ModuleException moduleException) {
            throw new WebApplicationException((Throwable)moduleException, this.createErrorResponse(moduleException, 500));
        }
        catch (ParseException parseException) {
            throw new WebApplicationException((Throwable)parseException, this.createErrorResponse(parseException, 500));
        }
    }

    private static String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    protected Response createErrorResponse(Throwable t, int status) {
        return Response.status((int)status).entity((Object)t.getMessage()).type("text/plain").build();
    }

    private Session getSession(String repoName, String repoPath) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository repo = this.repositoryService.getRepository(repoName);
        SessionProvider sp = this.sessionProviderService.getSessionProvider(null);
        if (sp == null) {
            throw new RepositoryException("SessionProvider is not properly set. Make the application callsSessionProviderService.setSessionProvider(..) somewhere before (for instance in Servlet Filter for WEB application)");
        }
        String workspace = repoPath.split("/")[0];
        return sp.getSession(workspace, repo);
    }
}

