/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.popup.info.UIPermissionForm;
import org.exoplatform.ecm.webui.component.explorer.popup.info.UIPermissionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPermissionInfo.msg.confirm-delete-permission"), @EventConfig(listeners={EditActionListener.class})})
public class UIPermissionInfo
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)UIPermissionInfo.class.getName());
    public static String[] PERMISSION_BEAN_FIELD = new String[]{"usersOrGroups", "read", "addNode", "setProperty", "remove"};
    private static String[] PERMISSION_ACTION = new String[]{"Edit", "Delete"};
    private int sizeOfListPermission = 0;
    private NodeLocation currentNode;

    public UIPermissionInfo() throws Exception {
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, "PermissionInfo");
        this.addChild((UIComponent)uiGrid);
        uiGrid.getUIPageIterator().setId("PermissionInfoIterator");
        uiGrid.configure("usersOrGroups", PERMISSION_BEAN_FIELD, PERMISSION_ACTION);
    }

    private String getExoOwner(Node node) throws Exception {
        return Utils.getNodeOwner((Node)node);
    }

    public void updateGrid(int currentPage) throws Exception {
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ArrayList<PermissionBean> permBeans = new ArrayList<PermissionBean>();
        ExtendedNode node = (ExtendedNode)uiJCRExplorer.getCurrentNode();
        List permsList = node.getACL().getPermissionEntries();
        HashMap permsMap = new HashMap();
        for (AccessControlEntry accessControlEntry : permsList) {
            String currentIdentity = accessControlEntry.getIdentity();
            String currentPermission = accessControlEntry.getPermission();
            ArrayList<String> currentPermissionsList = (ArrayList<String>)permsMap.get(currentIdentity);
            if (!permsMap.containsKey(currentIdentity)) {
                permsMap.put(currentIdentity, null);
            }
            if (currentPermissionsList == null) {
                currentPermissionsList = new ArrayList<String>();
            }
            if (!currentPermissionsList.contains(currentPermission)) {
                currentPermissionsList.add(currentPermission);
            }
            permsMap.put(currentIdentity, currentPermissionsList);
        }
        Set keys = permsMap.keySet();
        Iterator keysIter = keys.iterator();
        int iSystemOwner = 0;
        String owner = IdentityConstants.SYSTEM;
        if (this.getExoOwner((Node)node) != null) {
            owner = this.getExoOwner((Node)node);
        }
        if (owner.equals(IdentityConstants.SYSTEM)) {
            iSystemOwner = -1;
        }
        PermissionBean permOwnerBean = new PermissionBean();
        if (!permsMap.containsKey(owner)) {
            permOwnerBean.setUsersOrGroups(owner);
            permOwnerBean.setRead(true);
            permOwnerBean.setAddNode(true);
            permOwnerBean.setSetProperty(true);
            permOwnerBean.setRemove(true);
            permBeans.add(permOwnerBean);
        }
        while (keysIter.hasNext()) {
            String userOrGroup = (String)keysIter.next();
            List permissions = (List)permsMap.get(userOrGroup);
            PermissionBean permBean = new PermissionBean();
            permBean.setUsersOrGroups(userOrGroup);
            for (String perm : permissions) {
                if ("read".equals(perm)) {
                    permBean.setRead(true);
                    continue;
                }
                if ("add_node".equals(perm)) {
                    permBean.setAddNode(true);
                    continue;
                }
                if ("set_property".equals(perm)) {
                    permBean.setSetProperty(true);
                    continue;
                }
                if (!"remove".equals(perm)) continue;
                permBean.setRemove(true);
            }
            permBeans.add(permBean);
            this.sizeOfListPermission = permBeans.size() + iSystemOwner;
        }
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        ListAccessImpl permList = new ListAccessImpl(PermissionBean.class, permBeans);
        LazyPageList dataPageList = new LazyPageList((ListAccess)permList, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)dataPageList);
        if (currentPage > uiGrid.getUIPageIterator().getAvailablePage()) {
            uiGrid.getUIPageIterator().setCurrentPage(uiGrid.getUIPageIterator().getAvailablePage());
        } else {
            uiGrid.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public static String[] getPERMISSION_ACTION() {
        return PERMISSION_ACTION;
    }

    public static void setPERMISSION_ACTION(String[] permission_action) {
        PERMISSION_ACTION = permission_action;
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode);
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = NodeLocation.getNodeLocationByNode((Node)currentNode);
    }

    public int getSizeOfListPermission() {
        return this.sizeOfListPermission;
    }

    public void setSizeOfListPermission(int sizeOfListPermission) {
        this.sizeOfListPermission = sizeOfListPermission;
    }

    public class PermissionBean {
        private String usersOrGroups;
        private boolean read;
        private boolean addNode;
        private boolean setProperty;
        private boolean remove;

        public String getUsersOrGroups() {
            return this.usersOrGroups;
        }

        public void setUsersOrGroups(String s) {
            this.usersOrGroups = s;
        }

        public boolean isAddNode() {
            return this.addNode;
        }

        public void setAddNode(boolean b) {
            this.addNode = b;
        }

        public boolean isRead() {
            return this.read;
        }

        public void setRead(boolean b) {
            this.read = b;
        }

        public boolean isRemove() {
            return this.remove;
        }

        public void setRemove(boolean b) {
            this.remove = b;
        }

        public boolean isSetProperty() {
            return this.setProperty;
        }

        public void setSetProperty(boolean b) {
            this.setProperty = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIPermissionInfo> {
        public void execute(Event<UIPermissionInfo> event) throws Exception {
            UIPermissionInfo uicomp = (UIPermissionInfo)((Object)event.getSource());
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiJCRExplorer.getCurrentNode();
            uiJCRExplorer.addLockToken(currentNode);
            ExtendedNode node = (ExtendedNode)currentNode;
            String owner = IdentityConstants.SYSTEM;
            int iSystemOwner = 0;
            if (uicomp.getExoOwner((Node)node) != null) {
                owner = uicomp.getExoOwner((Node)node);
            }
            if (owner.equals(IdentityConstants.SYSTEM)) {
                iSystemOwner = -1;
            }
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            if (uicomp.getSizeOfListPermission() < 2 + iSystemOwner) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.no-permission-remove", null, 1));
                return;
            }
            String name = event.getRequestContext().getRequestParameter("objectId");
            if (!currentNode.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                return;
            }
            String nodeOwner = Utils.getNodeOwner((Node)node);
            if (name.equals(nodeOwner)) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.no-permission-remove", null, 1));
                return;
            }
            if (PermissionUtil.canChangePermission((Node)node)) {
                if (node.canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                    node.setPermission(nodeOwner, PermissionType.ALL);
                }
                try {
                    node.removePermission(name);
                    node.save();
                }
                catch (AccessDeniedException ace) {
                    node.getSession().refresh(false);
                    uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.access-denied", null, 1));
                    return;
                }
                if (uiJCRExplorer.getRootNode().equals(node) && !PermissionUtil.canRead((Node)currentNode)) {
                    ((UIJCRExplorerPortlet)uiJCRExplorer.getAncestorOfType(UIJCRExplorerPortlet.class)).reloadWhenBroken(uiJCRExplorer);
                    return;
                }
            } else {
                uiApp.addMessage(new ApplicationMessage("UIPermissionInfo.msg.no-permission-tochange", null, 1));
                return;
            }
            node.getSession().save();
            UIPopupContainer uiPopup = (UIPopupContainer)uicomp.getAncestorOfType(UIPopupContainer.class);
            if (!PermissionUtil.canRead((Node)node)) {
                uiJCRExplorer.setSelectNode(LinkUtils.getParentPath((String)uiJCRExplorer.getCurrentPath()));
                uiPopup.deActivate();
            } else {
                uicomp.updateGrid(((UIGrid)uicomp.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage());
                event.getRequestContext().addUIComponentToUpdateByAjax(uicomp.getParent());
            }
            Node realNode = uiJCRExplorer.getRealCurrentNode();
            LinkManager linkManager = (LinkManager)uiJCRExplorer.getApplicationComponent(LinkManager.class);
            if (linkManager.isLink((Item)realNode)) {
                linkManager.updateLink(realNode, currentNode);
            }
            if (currentNode.isNodeType("mix:referenceable")) {
                List symlinks = linkManager.getAllLinks(currentNode, "exo:symlink");
                for (Node symlink : symlinks) {
                    try {
                        linkManager.updateLink(symlink, currentNode);
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)e.getMessage());
                    }
                }
            }
            currentNode.getSession().save();
            uiJCRExplorer.setIsHidePopup(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
            uiJCRExplorer.updateAjax(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIPermissionInfo> {
        public void execute(Event<UIPermissionInfo> event) throws Exception {
            UIPermissionInfo uicomp = (UIPermissionInfo)((Object)event.getSource());
            String name = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            ExtendedNode node = (ExtendedNode)uiJCRExplorer.getCurrentNode();
            UIPermissionForm uiForm = (UIPermissionForm)((UIPermissionManager)uicomp.getAncestorOfType(UIPermissionManager.class)).getChild(UIPermissionForm.class);
            uiForm.fillForm(name, node);
            uiForm.lockForm(name.equals(uicomp.getExoOwner((Node)node)));
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }
}

