/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.HashMap;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.utils.Utils;
import org.xwiki.rendering.syntax.Syntax;

public class WikiSpaceActivityPublisher
extends PageWikiListener {
    public static final String WIKI_APP_ID = "ks-wiki:spaces";
    public static final String ACTIVITY_TYPE_KEY = "act_key";
    public static final String ADD_PAGE_TYPE = "add_page";
    public static final String UPDATE_PAGE_TYPE = "update_page";
    public static final String PAGE_ID_KEY = "page_id";
    public static final String PAGE_TYPE_KEY = "page_type";
    public static final String PAGE_OWNER_KEY = "page_owner";
    public static final String PAGE_TITLE_KEY = "page_name";
    public static final String URL_KEY = "page_url";
    public static final String PAGE_EXCERPT = "page_exceprt";
    public static final String VIEW_CHANGE_URL_KEY = "view_change_url";
    public static final String VIEW_CHANGE_ANCHOR = "#CompareRevision/changes";
    public static final String WIKI_PAGE_NAME = "wiki";
    private static final int EXCERPT_LENGTH = 140;
    private static Log LOG = ExoLogger.getExoLogger(WikiSpaceActivityPublisher.class);

    private ExoSocialActivity activity(Identity ownerIdentity, String wikiType, String wikiOwner, String pageId, Page page, String spaceUrl, String activityType) throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId(ownerIdentity.getId());
        activity.setTitle("title");
        activity.setBody("body");
        activity.setType(WIKI_APP_ID);
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(PAGE_ID_KEY, pageId);
        templateParams.put(ACTIVITY_TYPE_KEY, activityType);
        templateParams.put(PAGE_OWNER_KEY, wikiOwner);
        templateParams.put(PAGE_TYPE_KEY, wikiType);
        templateParams.put(PAGE_TITLE_KEY, page.getTitle());
        String pageURL = page.getURL() == null ? (spaceUrl != null ? spaceUrl + "/" + WIKI_PAGE_NAME : "") : page.getURL();
        templateParams.put(URL_KEY, pageURL);
        String excerpt = "";
        if (ADD_PAGE_TYPE.equals(activityType)) {
            RenderingService renderingService = (RenderingService)PortalContainer.getInstance().getComponentInstanceOfType(RenderingService.class);
            excerpt = renderingService.render(page.getContent().getText(), page.getSyntax(), Syntax.PLAIN_1_0.toIdString(), false);
        } else {
            String verName = ((PageImpl)page).getVersionableMixin().getBaseVersion().getName();
            templateParams.put(VIEW_CHANGE_URL_KEY, Utils.getURL((String)page.getURL(), (String)verName));
            excerpt = page.getComment();
        }
        excerpt = excerpt.length() > 140 ? excerpt.substring(0, 140) + "..." : excerpt;
        templateParams.put(PAGE_EXCERPT, excerpt);
        templateParams.put("registeredKeysForProcessor", PAGE_EXCERPT);
        activity.setTemplateParams(templateParams);
        return activity;
    }

    private boolean isPublic(Page page) throws Exception {
        HashMap permissions = page.getPermission();
        return permissions != null && permissions.containsKey(IdentityConstants.ANY) && ArrayUtils.contains((Object[])((Object[])permissions.get(IdentityConstants.ANY)), (Object)"read");
    }

    private boolean isPublicInSpace(Page page, Space space) throws Exception {
        String groupMemberShip;
        HashMap pagePermissions = page.getPermission();
        return pagePermissions.containsKey(groupMemberShip = "*:" + space.getGroupId()) && ArrayUtils.contains((Object[])((Object[])pagePermissions.get(groupMemberShip)), (Object)"read");
    }

    private void saveActivity(String wikiType, String wikiOwner, String pageId, Page page, String addType) throws Exception {
        String spaceUrl;
        ExoSocialActivity activity;
        Identity authorActivity;
        Identity ownerStream;
        Identity userIdentity;
        ActivityManager activityM;
        block10: {
            try {
                Class.forName("org.exoplatform.social.core.space.spi.SpaceService");
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"eXo Social components not found!", (Throwable)e);
                }
                return;
            }
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            IdentityManager identityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            userIdentity = identityM.getOrCreateIdentity("organization", username, false);
            ownerStream = null;
            authorActivity = userIdentity;
            activity = null;
            spaceUrl = null;
            if (PortalConfig.GROUP_TYPE.equals(wikiType)) {
                String groupId = "/" + wikiOwner;
                SpaceService spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
                Space space = null;
                try {
                    space = spaceService.getSpaceByGroupId(groupId);
                    if (space != null) {
                        if (!this.isPublicInSpace(page, space)) {
                            return;
                        }
                        ownerStream = identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
                        spaceUrl = space.getUrl();
                    }
                }
                catch (SpaceStorageException e) {
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.debug((Object)String.format("Space %s not existed", groupId), (Throwable)e);
                }
            }
        }
        if (ownerStream == null && this.isPublic(page)) {
            ownerStream = userIdentity;
        }
        if (ownerStream != null) {
            activity = this.activity(authorActivity, wikiType, wikiOwner, pageId, page, spaceUrl, addType);
            activityM.saveActivityNoReturn(ownerStream, activity);
        }
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws Exception {
        if ("WikiHome".equals(pageId)) {
            return;
        }
        this.saveActivity(wikiType, wikiOwner, pageId, page, ADD_PAGE_TYPE);
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) {
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page) throws Exception {
        if (page != null && !((PageImpl)page).isMinorEdit()) {
            this.saveActivity(wikiType, wikiOwner, pageId, page, UPDATE_PAGE_TYPE);
        }
    }
}

