/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JDBCUtils {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCUtils");

    private JDBCUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExists(String tableName, Connection con) {
        boolean bl;
        Statement stmt = null;
        ResultSet trs = null;
        try {
            String dialect = DialectDetecter.detect(con.getMetaData());
            String query = DBConstants.DB_DIALECT_MYSQL.equals(dialect) ? "SELECT count(*) from (SELECT 1 FROM " + tableName + " LIMIT 1) T" : "SELECT count(*) FROM " + tableName;
            stmt = con.createStatement();
            trs = stmt.executeQuery(query);
            bl = trs.next();
            Object var8_9 = null;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQLException occurs while checking the table " + tableName), (Throwable)e);
                }
                bl2 = false;
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                JDBCUtils.freeResources(trs, stmt, null);
                throw throwable;
            }
            JDBCUtils.freeResources(trs, stmt, null);
            return bl2;
        }
        JDBCUtils.freeResources(trs, stmt, null);
        return bl;
    }

    public static void freeResources(ResultSet resultSet, Statement statement, Connection conn) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

