/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UIAnyPermission;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/ecm/webui/UIMemberSelector.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={SelectMembershipActionListener.class}), @EventConfig(listeners={SelectPathActionListener.class}), @EventConfig(listeners={AddAnyPermissionActionListener.class})}), @ComponentConfig(type=UITree.class, id="UITreeMembershipSelector", template="system:/groovy/webui/core/UITree.gtmpl", events={@EventConfig(listeners={UITree.ChangeNodeActionListener.class})}), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbMembershipSelector", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={UIBreadcumbs.SelectPathActionListener.class})})})
public class UIGroupMemberSelector
extends UIContainer
implements ComponentSelector {
    public static final String defaultValue = "/admin";
    private UIComponent uiComponent;
    private String returnFieldName = null;
    private boolean isSelectedMembership = true;
    private boolean isSelectedUser;
    private boolean isUsePopup = true;
    private boolean isShowAnyPermission = true;
    private Group selectGroup_;
    private List<String> listMemberhip;

    public UIGroupMemberSelector() throws Exception {
        this.addChild(UIAnyPermission.class, null, null);
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.addChild(UIBreadcumbs.class, "BreadcumbMembershipSelector", "BreadcumbMembershipSelector");
        UITree tree = (UITree)this.addChild(UITree.class, "UITreeMembershipSelector", "TreeMembershipSelector");
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        Collection sibblingsGroup = service.getGroupHandler().findGroups(null);
        Collection collection = service.getMembershipTypeHandler().findMembershipTypes();
        this.listMemberhip = new ArrayList<String>(5);
        for (Object obj : collection) {
            this.listMemberhip.add(((MembershipType)obj).getName());
        }
        if (!this.listMemberhip.contains("*")) {
            this.listMemberhip.add("*");
        }
        Collections.sort(this.listMemberhip);
        tree.setSibbling((Collection)((List)sibblingsGroup));
        tree.setIcon("GroupAdminIcon");
        tree.setSelectedIcon("PortalIcon");
        tree.setBeanIdField("id");
        tree.setBeanLabelField("groupName");
        uiBreadcumbs.setBreadcumbsStyle("UIExplorerHistoryPath");
    }

    public Group getCurrentGroup() {
        return this.selectGroup_;
    }

    public List<String> getListMemberhip() {
        return this.listMemberhip;
    }

    public void changeGroup(String groupId) throws Exception {
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        UIBreadcumbs uiBreadcumb = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        uiBreadcumb.setPath(this.getPath(null, groupId));
        UITree tree = (UITree)this.getChild(UITree.class);
        if (groupId == null) {
            Collection sibblingGroup = service.getGroupHandler().findGroups(null);
            tree.setSibbling((Collection)((List)sibblingGroup));
            tree.setChildren(null);
            tree.setSelected(null);
            this.selectGroup_ = null;
            return;
        }
        this.selectGroup_ = service.getGroupHandler().findGroupById(groupId);
        String parentGroupId = null;
        if (this.selectGroup_ != null) {
            parentGroupId = this.selectGroup_.getParentId();
        }
        Group parentGroup = null;
        if (parentGroupId != null) {
            parentGroup = service.getGroupHandler().findGroupById(parentGroupId);
        }
        Collection childrenGroup = service.getGroupHandler().findGroups(this.selectGroup_);
        Collection sibblingGroup = service.getGroupHandler().findGroups(parentGroup);
        tree.setSibbling((Collection)((List)sibblingGroup));
        tree.setChildren((Collection)((List)childrenGroup));
        tree.setSelected((Object)this.selectGroup_);
        tree.setParentSelected((Object)parentGroup);
    }

    private List<UIBreadcumbs.LocalPath> getPath(List<UIBreadcumbs.LocalPath> list, String id) throws Exception {
        if (list == null) {
            list = new ArrayList<UIBreadcumbs.LocalPath>(5);
        }
        if (id == null) {
            return list;
        }
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        Group group = service.getGroupHandler().findGroupById(id);
        if (group == null) {
            return list;
        }
        list.add(0, new UIBreadcumbs.LocalPath(group.getId(), group.getGroupName()));
        this.getPath(list, group.getParentId());
        return list;
    }

    public List<String> getListGroup() throws Exception {
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        ArrayList<String> listGroup = new ArrayList<String>();
        if (this.getCurrentGroup() == null) {
            return null;
        }
        Collection groups = service.getGroupHandler().findGroups(this.getCurrentGroup());
        if (groups.size() > 0) {
            for (Object child : groups) {
                Group childGroup = (Group)child;
                listGroup.add(childGroup.getId());
            }
        }
        return listGroup;
    }

    @Override
    public UIComponent getSourceComponent() {
        return this.uiComponent;
    }

    public String getReturnField() {
        return this.returnFieldName;
    }

    public void setIsUsePopup(boolean isUsePopup) {
        this.isUsePopup = isUsePopup;
    }

    public boolean isUsePopup() {
        return this.isUsePopup;
    }

    public void setSelectedUser(boolean bool) {
        this.isSelectedUser = bool;
    }

    public boolean isSelectedUser() {
        return this.isSelectedUser;
    }

    public void setSelectedMembership(boolean bool) {
        this.isSelectedMembership = bool;
    }

    public boolean isSelectedMembership() {
        return this.isSelectedMembership;
    }

    @Override
    public void setSourceComponent(UIComponent uicomponent, String[] initParams) {
        this.uiComponent = uicomponent;
        if (initParams == null || initParams.length == 0) {
            return;
        }
        for (int i = 0; i < initParams.length; ++i) {
            if (initParams[i].indexOf("returnField") > -1) {
                String[] array = initParams[i].split("=");
                this.returnFieldName = array[1];
                break;
            }
            this.returnFieldName = initParams[0];
        }
    }

    public String event(String name, String beanId) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        if (uiForm != null) {
            return uiForm.event(name, this.getId(), beanId);
        }
        return super.event(name, beanId);
    }

    public boolean isShowAnyPermission() {
        return this.isShowAnyPermission;
    }

    public void setShowAnyPermission(boolean isShowAnyPermission) {
        this.isShowAnyPermission = isShowAnyPermission;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddAnyPermissionActionListener
    extends EventListener<UIAnyPermission> {
        public void execute(Event<UIAnyPermission> event) throws Exception {
            UIAnyPermission uiAnyPermission = (UIAnyPermission)((Object)event.getSource());
            UIGroupMemberSelector uiGroupMemberSelector = (UIGroupMemberSelector)uiAnyPermission.getParent();
            String returnField = uiGroupMemberSelector.getReturnField();
            String value = IdentityConstants.ANY;
            ((UISelectable)uiGroupMemberSelector.getSourceComponent()).doSelect(returnField, value);
            if (uiGroupMemberSelector.isUsePopup()) {
                UIPopupWindow uiPopup = (UIPopupWindow)uiGroupMemberSelector.getParent();
                uiPopup.setShow(false);
                UIComponent uicomp = uiGroupMemberSelector.getSourceComponent().getParent();
                event.getRequestContext().addUIComponentToUpdateByAjax(uicomp);
                if (!uiPopup.getId().equals("PopupComponent")) {
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
                }
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiGroupMemberSelector.getSourceComponent());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            UIGroupMemberSelector uiGroupMemberSelector = (UIGroupMemberSelector)uiBreadcumbs.getParent();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiBreadcumbs.setSelectPath(objectId);
            String selectGroupId = uiBreadcumbs.getSelectLocalPath().getId();
            uiGroupMemberSelector.changeGroup(selectGroupId);
            if (uiGroupMemberSelector.isUsePopup) {
                UIPopupWindow uiPopup = (UIPopupWindow)uiBreadcumbs.getAncestorOfType(UIPopupWindow.class);
                uiPopup.setShow(true);
                uiPopup.setShowMask(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiGroupMemberSelector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectMembershipActionListener
    extends EventListener<UIGroupMemberSelector> {
        public void execute(Event<UIGroupMemberSelector> event) throws Exception {
            UIGroupMemberSelector uiGroupMemberSelector = (UIGroupMemberSelector)event.getSource();
            if (uiGroupMemberSelector.getCurrentGroup() == null) {
                return;
            }
            String groupId = uiGroupMemberSelector.getCurrentGroup().getId();
            String permission = event.getRequestContext().getRequestParameter("objectId");
            String value = "";
            value = uiGroupMemberSelector.isSelectedUser() ? permission : permission + ":" + groupId;
            String returnField = uiGroupMemberSelector.getReturnField();
            ((UISelectable)uiGroupMemberSelector.getSourceComponent()).doSelect(returnField, value);
            if (uiGroupMemberSelector.isUsePopup) {
                UIPopupWindow uiPopup = (UIPopupWindow)uiGroupMemberSelector.getParent();
                uiPopup.setShow(false);
                UIComponent uicomp = uiGroupMemberSelector.getSourceComponent().getParent();
                event.getRequestContext().addUIComponentToUpdateByAjax(uicomp);
                if (!uiPopup.getId().equals("PopupComponent")) {
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
                }
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiGroupMemberSelector.getSourceComponent());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            UIGroupMemberSelector uiGroupMemberSelector = (UIGroupMemberSelector)((UITree)event.getSource()).getParent();
            String groupId = event.getRequestContext().getRequestParameter("objectId");
            uiGroupMemberSelector.changeGroup(groupId);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiGroupMemberSelector);
        }
    }
}

