/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.selector.content.UIContentBrowsePanel;
import org.exoplatform.wcm.webui.selector.content.UIContentSelector;
import org.exoplatform.wcm.webui.viewer.UIContentViewer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={SelectActionListener.class}), @EventConfig(listeners={ViewActionListener.class})})
public class UIContentSearchResult
extends UIGrid {
    public static final String TITLE = "title";
    public static final String NODE_EXPECT = "excerpt";
    public static final String SCORE = "score";
    public static final String CREATE_DATE = "CreateDate";
    public static final String PUBLICATION_STATE = "publicationstate";
    public static final String NODE_PATH = "path";
    public String[] Actions = new String[]{"Select", "View"};
    public String[] BEAN_FIELDS = new String[]{"title", "score", "publicationstate"};

    public UIContentSearchResult() throws Exception {
        this.configure(NODE_PATH, this.BEAN_FIELDS, this.Actions);
        this.getUIPageIterator().setId("UIWCMSearchResultPaginator");
    }

    public DateFormat getDateFormat() {
        Locale locale = new Locale(Util.getUIPortal().getLocale());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, locale);
        return dateFormat;
    }

    public void updateGrid(AbstractPageList<ResultNode> pageList) throws Exception {
        this.getUIPageIterator().setPageList(pageList);
    }

    public String getTitleNode(Node node) throws Exception {
        return node.hasProperty("exo:title") ? node.getProperty("exo:title").getValue().getString() : node.getName();
    }

    public Date getCreateDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar cal = node.getProperty("exo:dateCreated").getValue().getDate();
            return cal.getTime();
        }
        return null;
    }

    public String getExpect(String expect) {
        expect = expect.replaceAll("<[^>]*/?>", "");
        return expect;
    }

    public String getCurrentState(Node node) throws Exception {
        PublicationService pubService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        return pubService.getCurrentState(node);
    }

    public Session getSession() throws Exception {
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository maRepository = repoService.getCurrentRepository();
        String repository = maRepository.getConfiguration().getName();
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences prefs = pContext.getRequest().getPreferences();
        String workspace = prefs.getValue("workspace", null);
        if (workspace == null) {
            WCMConfigurationService wcmConfService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
            NodeLocation nodeLocation = wcmConfService.getLivePortalsLocation(repository);
            workspace = nodeLocation.getWorkspace();
        }
        Session session = WCMCoreUtils.getUserSessionProvider().getSession(workspace, maRepository);
        return session;
    }

    public String getWorkspaceName(Node node) throws Exception {
        return node.getSession().getWorkspace().getName();
    }

    public String getRepository() throws Exception {
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository maRepository = repoService.getCurrentRepository();
        return maRepository.getConfiguration().getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewActionListener
    extends EventListener<UIContentSearchResult> {
        public void execute(Event<UIContentSearchResult> event) throws Exception {
            String nodeType;
            UIContentSearchResult contentSearchResult = (UIContentSearchResult)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)contentSearchResult.getAncestorOfType(UIApplication.class);
            String expression = event.getRequestContext().getRequestParameter("objectId");
            NodeLocation nodeLocation = NodeLocation.getNodeLocationByExpression((String)expression);
            String repository = nodeLocation.getRepository();
            String workspace = nodeLocation.getWorkspace();
            String webcontentPath = nodeLocation.getPath();
            Node originalNode = Utils.getViewableNodeByComposer(repository, workspace, webcontentPath, "base");
            Node viewNode = Utils.getViewableNodeByComposer(repository, workspace, webcontentPath);
            TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
            if (templateService.isManagedNodeType(nodeType = originalNode.getPrimaryNodeType().getName())) {
                UIContentSelector contentSelector = (UIContentSelector)contentSearchResult.getAncestorOfType(UIContentSelector.class);
                UIContentViewer contentResultViewer = (UIContentViewer)contentSelector.getChild(UIContentViewer.class);
                if (contentResultViewer == null) {
                    contentResultViewer = (UIContentViewer)contentSelector.addChild(UIContentViewer.class, null, null);
                }
                contentResultViewer.setNode(viewNode);
                contentResultViewer.setOriginalNode(originalNode);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentSelector);
                contentSelector.setSelectedTab(contentResultViewer.getId());
            } else {
                uiApp.addMessage(new ApplicationMessage("UIContentSearchResult.msg.template-not-support", null, 1));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UIContentSearchResult> {
        public void execute(Event<UIContentSearchResult> event) throws Exception {
            UIContentSearchResult contentSearchResult = (UIContentSearchResult)((Object)event.getSource());
            UIContentSelector contentSelector = (UIContentSelector)contentSearchResult.getAncestorOfType(UIContentSelector.class);
            UIContentBrowsePanel contentBrowsePanel = (UIContentBrowsePanel)contentSelector.getChild(UIContentBrowsePanel.class);
            ((UISelectable)contentBrowsePanel.getSourceComponent()).doSelect(contentBrowsePanel.getReturnFieldName(), event.getRequestContext().getRequestParameter("objectId"));
        }
    }
}

