/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestLoader;
import org.exoplatform.services.jcr.ext.script.groovy.NodeScriptKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.ext.groovy.ResourceId;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;

public class GroovyScript2RestUpdateListener
implements EventListener {
    private static final Log LOG = ExoLogger.getLogger("exo.jcr.component.ext.GroovyScript2RestUpdateListener");
    private final ManageableRepository repository;
    private final String workspaceName;
    private final GroovyScript2RestLoader groovyScript2RestLoader;

    public GroovyScript2RestUpdateListener(ManageableRepository repository, String workspace, GroovyScript2RestLoader groovyScript2RestLoader) {
        this.repository = repository;
        this.workspaceName = workspace;
        this.groovyScript2RestLoader = groovyScript2RestLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator eventIterator) {
        Session session = null;
        try {
            while (eventIterator.hasNext()) {
                Node node;
                Event event = eventIterator.nextEvent();
                String path = event.getPath();
                if (!path.endsWith("/jcr:data")) continue;
                if (event.getType() == 8) {
                    this.unloadScript(path.substring(0, path.lastIndexOf(47)));
                    continue;
                }
                if (event.getType() != 4 && event.getType() != 16) continue;
                if (session == null) {
                    session = this.repository.getSystemSession(this.workspaceName);
                }
                if (!(node = session.getItem(path).getParent()).getProperty("exo:autoload").getBoolean()) continue;
                this.loadScript(node);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Process event failed. ", e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private void loadScript(Node node) throws Exception {
        NodeScriptKey key = new NodeScriptKey(this.repository.getConfiguration().getName(), this.workspaceName, node);
        ObjectFactory resource = this.groovyScript2RestLoader.groovyPublisher.unpublishResource((ResourceId)key);
        if (resource != null) {
            this.groovyScript2RestLoader.groovyPublisher.publishPerRequest(node.getProperty("jcr:data").getStream(), (ResourceId)key, ((AbstractResourceDescriptor)resource.getObjectModel()).getProperties());
        } else {
            this.groovyScript2RestLoader.groovyPublisher.publishPerRequest(node.getProperty("jcr:data").getStream(), (ResourceId)key, null);
        }
    }

    private void unloadScript(String path) throws Exception {
        NodeScriptKey key = new NodeScriptKey(this.repository.getConfiguration().getName(), this.workspaceName, path);
        this.groovyScript2RestLoader.groovyPublisher.unpublishResource((ResourceId)key);
    }
}

