/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionPlugin;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.DMSEvent;
import org.exoplatform.services.cms.actions.impl.BaseActionPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionServiceContainerImpl
implements ActionServiceContainer,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)ActionServiceContainerImpl.class.getName());
    private static final String ACTIONABLE = "exo:actionable";
    private static final String ACTION = "exo:action";
    private static final String JOB_NAME_PROP = "exo:jobName";
    private static final String JOB_GROUP_PROP = "exo:jobGroup";
    private static final String JOB_CLASS_PROP = "exo:jobClass";
    private static final String LIFECYCLE_PHASE_PROP = "exo:lifecyclePhase";
    private static final String ACTION_QUERY = "//element(*, exo:action)";
    private static final String ACTION_SQL_QUERY = "select * from exo:action";
    private static final String WHERE_OPERATOR = " where";
    private static final String JCR_PATH = " jcr:path";
    private static final String LIKE_OPERATOR = " like";
    private static final String SINGLE_QUOTE = "'";
    private static final String SCHEDULABLE_MIXIN = "exo:schedulableInfo";
    private static final String EXO_ACTIONS = "exo:actions";
    private static final String ACTION_STORAGE = "exo:actionStorage";
    private static final String EXO_HIDDENABLE = "exo:hiddenable";
    private RepositoryService repositoryService_;
    private CmsService cmsService_;
    private Collection<ComponentPlugin> actionPlugins = new ArrayList<ComponentPlugin>();

    public ActionServiceContainerImpl(RepositoryService repositoryService, CmsService cmsService) throws Exception {
        this.repositoryService_ = repositoryService;
        this.cmsService_ = cmsService;
    }

    public void start() {
        block4: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Start " + this.getClass().getSimpleName() + "..."));
            }
            try {
                for (ComponentPlugin cPlungin : this.actionPlugins) {
                    BaseActionPlugin plugin = (BaseActionPlugin)cPlungin;
                    plugin.importPredefinedActionsInJcr();
                }
                this.initiateActionConfiguration();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"Cannot start ActionServiceContainerImpl", (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    @Override
    @Deprecated
    public void init(String repository) {
        this.init();
    }

    @Override
    public void init() {
        block3: {
            try {
                for (ComponentPlugin cPlungin : this.actionPlugins) {
                    BaseActionPlugin plugin = (BaseActionPlugin)cPlungin;
                    plugin.reImportPredefinedActionsInJcr();
                }
                this.reInitiateActionConfiguration();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Cannot initialize the ActionServiceContainerImpl", (Throwable)e);
            }
        }
    }

    @Override
    public Collection<String> getActionPluginNames() {
        ArrayList<String> actionPluginNames = new ArrayList<String>(this.actionPlugins.size());
        for (ComponentPlugin plugin : this.actionPlugins) {
            actionPluginNames.add(plugin.getName());
        }
        return actionPluginNames;
    }

    @Override
    public ActionPlugin getActionPlugin(String actionsServiceName) {
        for (ComponentPlugin plugin : this.actionPlugins) {
            if (!plugin.getName().equals(actionsServiceName)) continue;
            return (ActionPlugin)plugin;
        }
        return null;
    }

    @Override
    public void createActionType(String actionTypeName, String parentActionTypeName, String executable, List<String> variableNames, boolean isMoveType, String repository) throws Exception {
        NodeTypeValue nodeTypeValue = new NodeTypeValue();
        nodeTypeValue.setName(actionTypeName);
        ArrayList<String> superTypes = new ArrayList<String>();
        superTypes.add(parentActionTypeName);
        if (isMoveType) {
            superTypes.add("exo:move");
        }
        nodeTypeValue.setDeclaredSupertypeNames(superTypes);
        ArrayList<PropertyDefinitionValue> propDefs = new ArrayList<PropertyDefinitionValue>();
        PropertyDefinitionValue propDef = null;
        for (String variableName : variableNames) {
            propDef = this.createPropertyDef(variableName);
            propDefs.add(propDef);
        }
        propDef = this.createPropertyDef(this.getActionPluginForActionType(parentActionTypeName).getExecutableDefinitionName());
        ArrayList<String> defaultValues = new ArrayList<String>();
        defaultValues.add(executable);
        propDef.setDefaultValueStrings(defaultValues);
        propDef.setMandatory(false);
        propDefs.add(propDef);
        nodeTypeValue.setDeclaredPropertyDefinitionValues(propDefs);
        nodeTypeValue.setDeclaredChildNodeDefinitionValues(new ArrayList());
        ExtendedNodeTypeManager ntmanager = this.repositoryService_.getCurrentRepository().getNodeTypeManager();
        ntmanager.registerNodeType(nodeTypeValue, 0);
    }

    private PropertyDefinitionValue createPropertyDef(String name) {
        PropertyDefinitionValue def = new PropertyDefinitionValue();
        def.setName(name);
        def.setRequiredType(1);
        def.setMandatory(false);
        def.setMultiple(false);
        def.setReadOnly(false);
        def.setAutoCreate(false);
        def.setOnVersion(1);
        def.setValueConstraints(new ArrayList());
        def.setDefaultValueStrings(new ArrayList());
        return def;
    }

    @Override
    public Collection<NodeType> getCreatedActionTypes(String repository) throws Exception {
        ArrayList<NodeType> createsActions = new ArrayList<NodeType>();
        ExtendedNodeTypeManager ntmanager = this.repositoryService_.getCurrentRepository().getNodeTypeManager();
        NodeTypeIterator iter = ntmanager.getAllNodeTypes();
        while (iter.hasNext()) {
            NodeType nt = (NodeType)iter.next();
            String name = nt.getName();
            if (!nt.isNodeType(ACTION) || this.isAbstractType(name)) continue;
            createsActions.add(nt);
        }
        return createsActions;
    }

    private boolean isAbstractType(String name) {
        for (ComponentPlugin plugin : this.actionPlugins) {
            if (!plugin.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private Session getSystemSession(String workspace) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository jcrRepository = this.repositoryService_.getCurrentRepository();
        return jcrRepository.getSystemSession(workspace);
    }

    @Override
    public ActionPlugin getActionPluginForActionType(String actionTypeName) {
        for (ComponentPlugin plugin : this.actionPlugins) {
            String actionServiceName = plugin.getName();
            ActionPlugin actionService = this.getActionPlugin(actionServiceName);
            if (!actionService.isActionTypeSupported(actionTypeName) && !actionServiceName.equals(actionTypeName)) continue;
            return actionService;
        }
        return null;
    }

    @Override
    public Node getAction(Node node, String actionName) throws Exception {
        NodeIterator nodeIter = node.getNodes(EXO_ACTIONS);
        if (nodeIter.hasNext()) {
            Node child = nodeIter.nextNode();
            try {
                return child.getNode(actionName);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean hasActions(Node node) throws Exception {
        return node.isNodeType(ACTIONABLE);
    }

    @Override
    public List<Node> getActions(Node node) throws Exception {
        return this.getActions(node, null);
    }

    @Override
    public List<Node> getCustomActionsNode(Node node, String lifecyclePhase) throws Exception {
        try {
            return this.getActions(node, lifecyclePhase);
        }
        catch (Exception item) {
            return null;
        }
    }

    @Override
    public List<Node> getActions(Node node, String lifecyclePhase) throws Exception {
        ArrayList<Node> actions = new ArrayList<Node>();
        Node actionStorage = null;
        try {
            actionStorage = node.getNodes(EXO_ACTIONS).nextNode();
        }
        catch (Exception e) {
            return actions;
        }
        NodeIterator iter = actionStorage.getNodes();
        while (iter.hasNext()) {
            Node tmpNode = iter.nextNode();
            if (!tmpNode.isNodeType(ACTION) || lifecyclePhase != null && !this.parseValuesToList(tmpNode.getProperty(LIFECYCLE_PHASE_PROP).getValues()).contains(lifecyclePhase)) continue;
            actions.add(tmpNode);
        }
        return actions;
    }

    @Override
    public void removeAction(Node node, String repository) throws Exception {
        if (!node.isNodeType(ACTIONABLE)) {
            return;
        }
        List<Node> actions = this.getActions(node);
        for (Node action : actions) {
            this.removeAction(node, action.getName(), repository);
        }
    }

    @Override
    public void removeAction(Node node, String actionName, String repository) throws Exception {
        if (!node.isNodeType(ACTIONABLE)) {
            return;
        }
        Node action2Remove = this.getAction(node, actionName);
        String[] lifecyclePhase = this.parseValuesToArray(action2Remove.getProperty(LIFECYCLE_PHASE_PROP).getValues());
        String jobName = null;
        String jobGroup = null;
        String jobClassName = null;
        if (action2Remove.isNodeType(SCHEDULABLE_MIXIN)) {
            jobName = action2Remove.getProperty(JOB_NAME_PROP).getString();
            jobGroup = action2Remove.getProperty(JOB_GROUP_PROP).getString();
            jobClassName = action2Remove.getProperty(JOB_CLASS_PROP).getString();
        }
        String actionTypeName = action2Remove.getPrimaryNodeType().getName();
        String actionPath = action2Remove.getPath();
        for (ComponentPlugin plugin : this.actionPlugins) {
            String actionServiceName = plugin.getName();
            ActionPlugin actionService = this.getActionPlugin(actionServiceName);
            if (!actionService.isActionTypeSupported(actionTypeName)) continue;
            if ((DMSEvent.getEventTypes(lifecyclePhase) & 0x1000) > 0) {
                actionService.removeActivationJob(jobName, jobGroup, jobClassName);
            }
            actionService.removeObservation(repository, actionPath);
        }
        action2Remove.remove();
        node.save();
    }

    @Override
    @Deprecated
    public void addAction(Node storeActionNode, String repository, String actionType, boolean isDeep, String[] uuid, String[] nodeTypeNames, Map mappings) throws Exception {
        this.addAction(storeActionNode, actionType, isDeep, uuid, nodeTypeNames, mappings);
    }

    @Override
    public void addAction(Node storeActionNode, String actionType, boolean isDeep, String[] uuid, String[] nodeTypeNames, Map mappings) throws Exception {
        Node actionsNode = null;
        try {
            actionsNode = storeActionNode.getNode(EXO_ACTIONS);
        }
        catch (PathNotFoundException e) {
            actionsNode = storeActionNode.addNode(EXO_ACTIONS, ACTION_STORAGE);
            actionsNode.addMixin(EXO_HIDDENABLE);
            storeActionNode.save();
        }
        if (!storeActionNode.isNodeType(ACTIONABLE)) {
            storeActionNode.addMixin(ACTIONABLE);
            storeActionNode.save();
        }
        String newActionPath = this.cmsService_.storeNode(actionType, actionsNode, mappings, true);
        storeActionNode.save();
        String srcWorkspace = storeActionNode.getSession().getWorkspace().getName();
        String srcPath = storeActionNode.getPath();
        ActionPlugin actionService = this.getActionPluginForActionType(actionType);
        if (actionService == null) {
            throw new ClassNotFoundException("Not found any action's service compatible with action type " + actionType);
        }
        try {
            actionService.addAction(actionType, srcWorkspace, srcPath, isDeep, uuid, nodeTypeNames, mappings);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            Session session = this.getSystemSession(storeActionNode.getSession().getWorkspace().getName());
            Node actionNode = (Node)session.getItem(newActionPath);
            actionNode.remove();
            session.save();
            session.logout();
            throw e;
        }
    }

    @Override
    @Deprecated
    public void addAction(Node storeActionNode, String repository, String actionType, Map mappings) throws Exception {
        this.addAction(storeActionNode, actionType, mappings);
    }

    @Override
    public void addAction(Node storeActionNode, String actionType, Map mappings) throws Exception {
        boolean isDeep = true;
        String[] nodeTypeName = null;
        String[] uuid = null;
        if (mappings.containsKey("/node/exo:isDeep")) {
            isDeep = Boolean.valueOf(((JcrInputProperty)mappings.get("/node/exo:isDeep")).getValue().toString());
        }
        if (mappings.containsKey("/node/exo:uuid") && (uuid = (String[])((JcrInputProperty)mappings.get("/node/exo:uuid")).getValue()).length == 0) {
            uuid = null;
        }
        if (mappings.containsKey("/node/exo:nodeTypeName") && (nodeTypeName = (String[])((JcrInputProperty)mappings.get("/node/exo:nodeTypeName")).getValue()).length == 0) {
            nodeTypeName = null;
            mappings.remove("/node/exo:nodeTypeName");
        }
        this.addAction(storeActionNode, actionType, isDeep, uuid, nodeTypeName, mappings);
    }

    @Override
    public void executeAction(String userId, Node node, String actionName, String repository) throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("initiator", userId);
        variables.put("actionName", actionName);
        variables.put("nodePath", node.getPath());
        variables.put("srcWorkspace", node.getSession().getWorkspace().getName());
        variables.put("srcPath", node.getPath());
        NodeType nodeType = node.getPrimaryNodeType();
        String nodeTypeName = nodeType.getName();
        variables.put("document-type", nodeTypeName);
        Node actionNode = this.getAction(node, actionName);
        NodeType actionNodeType = actionNode.getPrimaryNodeType();
        this.fillVariables(actionNode, actionNodeType, variables);
        NodeType[] actionMixinTypes = actionNode.getMixinNodeTypes();
        for (int i = 0; i < actionMixinTypes.length; ++i) {
            NodeType mixinType = actionMixinTypes[i];
            this.fillVariables(actionNode, mixinType, variables);
        }
        this.executeAction(userId, node, actionName, variables, repository);
    }

    private void fillVariables(Node actionNode, NodeType nodeType, Map variables) throws Exception {
        for (PropertyDefinition def : nodeType.getDeclaredPropertyDefinitions()) {
            String propName = def.getName();
            if (!actionNode.hasProperty(propName) || actionNode.getProperty(propName).getDefinition().isMultiple()) continue;
            String propValue = actionNode.getProperty(propName).getString();
            variables.put(propName, propValue);
        }
    }

    @Override
    public void executeAction(String userId, Node node, String actionName, Map variables, String repository) throws Exception {
        if (!node.isNodeType(ACTIONABLE)) {
            return;
        }
        Node actionNode = this.getAction(node, actionName);
        String actionTypeName = actionNode.getPrimaryNodeType().getName();
        for (ComponentPlugin plugin : this.actionPlugins) {
            String actionServiceName = plugin.getName();
            ActionPlugin actionPlugin = this.getActionPlugin(actionServiceName);
            if (!actionPlugin.isActionTypeSupported(actionTypeName)) continue;
            actionPlugin.executeAction(userId, actionNode, variables, repository);
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        this.actionPlugins.add(plugin);
    }

    public ComponentPlugin removePlugin(String pluginName) {
        return null;
    }

    public Collection<ComponentPlugin> getPlugins() {
        return this.actionPlugins;
    }

    private void initiateActionConfiguration() throws Exception {
        String[] workspaces;
        ManageableRepository jcrRepository = null;
        jcrRepository = this.repositoryService_.getCurrentRepository();
        for (String workspace : workspaces = jcrRepository.getWorkspaceNames()) {
            QueryManager queryManager;
            Session session;
            block4: {
                session = jcrRepository.getSystemSession(workspace);
                queryManager = null;
                try {
                    queryManager = session.getWorkspace().getQueryManager();
                }
                catch (RepositoryException e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)("ActionServiceContainer - Query Manager Factory of workspace " + workspace + " not found. Check configuration."), (Throwable)e);
                }
            }
            if (queryManager == null) {
                session.logout();
                continue;
            }
            this.initAction(queryManager, workspace);
            session.logout();
        }
    }

    private void reInitiateActionConfiguration() throws Exception {
        ManageableRepository jcrRepository = this.repositoryService_.getCurrentRepository();
        for (String workspace : jcrRepository.getWorkspaceNames()) {
            QueryManager queryManager;
            Session session;
            block4: {
                session = jcrRepository.getSystemSession(workspace);
                queryManager = null;
                try {
                    queryManager = session.getWorkspace().getQueryManager();
                }
                catch (RepositoryException e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)("ActionServiceContainer - Query Manager Factory of workspace " + workspace + " not found. Check configuration."), (Throwable)e);
                }
            }
            if (queryManager == null) {
                session.logout();
                continue;
            }
            this.initAction(queryManager, workspace);
            session.logout();
        }
    }

    private void initAction(QueryManager queryManager, String workspace) throws Exception {
        block5: {
            try {
                Query query = queryManager.createQuery(ACTION_QUERY, "xpath");
                QueryResult queryResult = query.execute();
                NodeIterator iter = queryResult.getNodes();
                while (iter.hasNext()) {
                    Node actionNode = iter.nextNode();
                    String[] lifecyclePhase = this.parseValuesToArray(actionNode.getProperty(LIFECYCLE_PHASE_PROP).getValues());
                    String actionType = actionNode.getPrimaryNodeType().getName();
                    for (ComponentPlugin plugin : this.actionPlugins) {
                        String actionServiceName = plugin.getName();
                        ActionPlugin actionService = this.getActionPlugin(actionServiceName);
                        if (!actionService.isActionTypeSupported(actionType) || DMSEvent.getEventTypes(lifecyclePhase) == 2048) continue;
                        if ((DMSEvent.getEventTypes(lifecyclePhase) & 0x1000) > 0) {
                            actionService.reScheduleActivations(actionNode);
                        }
                        if (DMSEvent.getEventTypes(lifecyclePhase) == 4096) continue;
                        actionService.initiateActionObservation(actionNode);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)(">>>> Can not launch action listeners for workspace: " + workspace + " in current repository"), (Throwable)e);
            }
        }
    }

    @Override
    public void initiateObservation(Node node, String repository) throws Exception {
        block8: {
            try {
                String queryStr;
                Session session = node.getSession();
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query query = null;
                try {
                    queryStr = !"/".equals(node.getPath()) ? "/jcr:root" + node.getPath() + ACTION_QUERY : ACTION_QUERY;
                    query = queryManager.createQuery(queryStr, "xpath");
                }
                catch (InvalidQueryException invalid) {
                    queryStr = !"/".equals(node.getPath()) ? "select * from exo:action where jcr:path like'" + node.getPath() + "/" + "%" + SINGLE_QUOTE : ACTION_SQL_QUERY;
                    query = queryManager.createQuery(queryStr, "sql");
                }
                QueryResult queryResult = query.execute();
                NodeIterator iter = queryResult.getNodes();
                while (iter.hasNext()) {
                    Node actionNode = iter.nextNode();
                    try {
                        String actionType = actionNode.getPrimaryNodeType().getName();
                        for (ComponentPlugin plugin : this.actionPlugins) {
                            String actionServiceName = plugin.getName();
                            ActionPlugin actionService = this.getActionPlugin(actionServiceName);
                            if (!actionService.isActionTypeSupported(actionType)) continue;
                            actionService.initiateActionObservation(actionNode);
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)("Can not launch action listeners named is " + actionNode.getPath()), (Throwable)e);
                    }
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)("Can not launch action listeners inside " + node.getPath() + " node."), (Throwable)ex);
            }
        }
    }

    private String[] parseValuesToArray(Value[] values) throws Exception {
        return this.parseValuesToList(values).toArray(new String[0]);
    }

    private List<String> parseValuesToList(Value[] values) throws Exception {
        ArrayList<String> lstValues = new ArrayList<String>();
        for (Value value : values) {
            lstValues.add(value.getString());
        }
        return lstValues;
    }
}

