/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.jcr.util.VersionHistoryImporter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Log LOG = ExoLogger.getLogger((String)Utils.class.getName());
    private static final String ILLEGAL_SEARCH_CHARACTERS = "\\!^()+{}[]:\"-";
    public static final String MAPPING_FILE = "mapping.properties";
    public static final String EXO_SYMLINK = "exo:symlink";

    public static Node makePath(Node rootNode, String path, String nodetype) throws PathNotFoundException, RepositoryException {
        return Utils.makePath(rootNode, path, nodetype, null);
    }

    public static Node makePath(Node rootNode, String path, String nodetype, Map permissions) throws PathNotFoundException, RepositoryException {
        String[] tokens = path.split("/");
        Node node = rootNode;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.length() <= 0) continue;
            if (node.hasNode(token)) {
                node = node.getNode(token);
                continue;
            }
            node = node.addNode(token, nodetype);
            node.getSession().save();
            node = (Node)node.getSession().getItem(node.getPath());
            if (node.canAddMixin("exo:privilegeable")) {
                node.addMixin("exo:privilegeable");
            }
            if (permissions == null) continue;
            ((ExtendedNode)node).setPermissions(permissions);
        }
        rootNode.save();
        return node;
    }

    public static void processImportHistory(Node currentNode, InputStream versionHistorySourceStream, Map<String, String> mapHistoryValue) throws Exception {
        Map<String, byte[]> mapVersionHistoryData = Utils.getVersionHistoryData(versionHistorySourceStream);
        block3: for (String uuid : mapHistoryValue.keySet()) {
            for (String name : mapVersionHistoryData.keySet()) {
                if (!name.equals(uuid + ".xml")) continue;
                try {
                    byte[] versionHistoryData = mapVersionHistoryData.get(name);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(versionHistoryData);
                    String value = mapHistoryValue.get(uuid);
                    Node versionableNode = currentNode.getSession().getNodeByUUID(uuid);
                    Utils.importHistory((NodeImpl)versionableNode, inputStream, Utils.getBaseVersionUUID(value), Utils.getPredecessors(value), Utils.getVersionHistory(value));
                    currentNode.getSession().save();
                    continue block3;
                }
                catch (ItemNotFoundException item) {
                    currentNode.getSession().refresh(false);
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)("Can not found versionable node" + (Object)((Object)item)), (Throwable)item);
                }
                catch (Exception e) {
                    currentNode.getSession().refresh(false);
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)("Import version history failed " + e), (Throwable)e);
                }
            }
        }
    }

    private static Map<String, byte[]> getVersionHistoryData(InputStream versionHistorySourceStream) throws IOException {
        HashMap<String, byte[]> mapVersionHistoryData = new HashMap<String, byte[]>();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(versionHistorySourceStream));
        byte[] data = new byte[1024];
        ZipEntry entry = zipInputStream.getNextEntry();
        while (entry != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int available = -1;
            while ((available = zipInputStream.read(data, 0, 1024)) > -1) {
                out.write(data, 0, available);
            }
            mapVersionHistoryData.put(entry.getName(), out.toByteArray());
            out.close();
            zipInputStream.closeEntry();
            entry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        return mapVersionHistoryData;
    }

    private static void importHistory(NodeImpl versionableNode, InputStream versionHistoryStream, String baseVersionUuid, String[] predecessors, String versionHistory) throws RepositoryException, IOException {
        VersionHistoryImporter versionHistoryImporter = new VersionHistoryImporter(versionableNode, versionHistoryStream, baseVersionUuid, predecessors, versionHistory);
        versionHistoryImporter.doImport();
    }

    public static Map<String, String> getMapImportHistory(InputStream importHistorySourceStream) throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream(importHistorySourceStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        ZipEntry entry = zipInputStream.getNextEntry();
        HashMap<String, String> mapHistoryValue = new HashMap<String, String>();
        while (entry != null) {
            int available = -1;
            if (entry.getName().equals(MAPPING_FILE)) {
                String strLine;
                while ((available = zipInputStream.read(data, 0, 1024)) > -1) {
                    out.write(data, 0, available);
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                while ((strLine = br.readLine()) != null) {
                    if (strLine.indexOf("=") <= -1) continue;
                    mapHistoryValue.put(strLine.split("=")[0], strLine.split("=")[1]);
                }
                ((InputStream)inputStream).close();
                zipInputStream.closeEntry();
                break;
            }
            entry = zipInputStream.getNextEntry();
        }
        out.close();
        zipInputStream.close();
        return mapHistoryValue;
    }

    private static String getBaseVersionUUID(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        return arrHistoryValue[1];
    }

    private static String[] getPredecessors(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        String strPredecessors = arrHistoryValue[1];
        if (strPredecessors.indexOf(",") > -1) {
            return strPredecessors.split(",");
        }
        return new String[]{strPredecessors};
    }

    private static String getVersionHistory(String valueHistory) {
        String[] arrHistoryValue = valueHistory.split(";");
        return arrHistoryValue[0];
    }

    public static String getPersonalDrivePath(String parameterizedDrivePath, String userId) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        NodeHierarchyCreator nodeHierarchyCreator = WCMCoreUtils.getService(NodeHierarchyCreator.class);
        Node userNode = nodeHierarchyCreator.getUserNode(sessionProvider, userId);
        return StringUtils.replaceOnce((String)parameterizedDrivePath, (String)(nodeHierarchyCreator.getJcrPath("usersPath") + "/${userId}"), (String)userNode.getPath());
    }

    public static List<PropertyDefinition> getProperties(Node node) throws Exception {
        ArrayList<PropertyDefinition> properties = new ArrayList<PropertyDefinition>();
        NodeType nodetype = node.getPrimaryNodeType();
        ArrayList<NodeType> types = new ArrayList<NodeType>();
        types.add(nodetype);
        NodeType[] mixins = node.getMixinNodeTypes();
        if (mixins != null) {
            types.addAll(Arrays.asList(mixins));
        }
        for (NodeType nodeType : types) {
            for (PropertyDefinition property : nodeType.getPropertyDefinitions()) {
                String name = property.getName();
                if (name.equals("exo:internalUse") || property.isProtected() || node.hasProperty(name)) continue;
                properties.add(property);
            }
        }
        return properties;
    }

    public static boolean isInTrash(Node node) throws RepositoryException {
        TrashService trashService = WCMCoreUtils.getService(TrashService.class);
        return trashService.isInTrash(node);
    }

    public static String getTitle(Node node) throws Exception {
        Node content;
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (Exception ex) {
                title = null;
            }
        }
        if (title == null) {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                Node originalNode = node.getSession().getNodeByUUID(uuid);
                title = originalNode.getName();
            } else {
                title = node.getName();
            }
        }
        return StringEscapeUtils.escapeHtml((String)Text.unescapeIllegalJcrChars((String)title));
    }

    public static String escapeIllegalCharacterInQuery(String query) {
        String ret = query;
        if (ret != null) {
            for (char c : ILLEGAL_SEARCH_CHARACTERS.toCharArray()) {
                ret = ret.replace(c + "", "\\" + c);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeDeadSymlinks(Node node) throws Exception {
        if (Utils.isInTrash(node)) {
            return;
        }
        linkManager = WCMCoreUtils.getService(LinkManager.class);
        trashService = WCMCoreUtils.getService(TrashService.class);
        nodeHierarchyCreator = WCMCoreUtils.getService(NodeHierarchyCreator.class);
        trashPath = nodeHierarchyCreator.getJcrPath("newDocumentsTrashPath");
        trashWorkspace = WCMCoreUtils.getService(RepositoryService.class).getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        sessionProvider = SessionProvider.createSystemProvider();
        queue = new LinkedList<Node>();
        queue.add(node);
        nodeComparator = new Comparator<Node>(){

            @Override
            public int compare(Node node1, Node node2) {
                try {
                    String name1 = node1.getName();
                    String name2 = node2.getName();
                    if (name1.equals(name2)) {
                        int index1 = node1.getIndex();
                        int index2 = node2.getIndex();
                        return -1 * Integer.valueOf(index1).compareTo(index2);
                    }
                    return -1 * name1.compareTo(name2);
                }
                catch (RepositoryException e) {
                    return 0;
                }
            }
        };
        try {
            block9: while (true) {
                block13: {
                    if (queue.isEmpty() != false) return;
                    node = (Node)queue.poll();
                    if (node.isNodeType("exo:symlink")) continue;
                    try {
                        symlinks = linkManager.getAllLinks(node, "exo:symlink");
                        Collections.sort(symlinks, nodeComparator);
                        i$ = symlinks.iterator();
                        while (i$.hasNext()) {
                            var12_14 = symlink = i$.next();
                            synchronized (var12_14) {
                                trashService.moveToTrash(symlink, trashPath, trashWorkspace, sessionProvider, 1);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!Utils.LOG.isWarnEnabled()) break block13;
                        Utils.LOG.warn((Object)e.getMessage());
                    }
                }
                iter = node.getNodes();
                while (true) {
                    if (iter.hasNext()) ** break;
                    continue block9;
                    queue.add(iter.nextNode());
                }
                break;
            }
        }
        catch (Exception e) {
            if (Utils.LOG.isWarnEnabled() == false) return;
            Utils.LOG.warn((Object)e.getMessage());
            return;
        }
        finally {
            sessionProvider.close();
        }
    }

    public static Node getChildOfType(Node node, String childType) throws Exception {
        if (node == null) {
            return null;
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!child.isNodeType(childType)) continue;
            return child;
        }
        return null;
    }

    public static boolean hasChild(Node node, String childType) throws Exception {
        return Utils.getChildOfType(node, childType) != null;
    }

    public static boolean isDocument(Node node) throws Exception {
        TemplateService templateService = WCMCoreUtils.getService(TemplateService.class);
        List<String> documentTypeList = templateService.getDocumentTemplates();
        for (String documentType : documentTypeList) {
            if (!node.getPrimaryNodeType().isNodeType(documentType)) continue;
            return true;
        }
        return false;
    }

    public static Node getServiceLogContentNode(String serviceName, String logType) throws Exception {
        ManageableRepository repository = WCMCoreUtils.getRepository();
        Session session = WCMCoreUtils.getSystemSessionProvider().getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
        Node serviceLogContentNode = null;
        if (session.getRootNode().hasNode("exo:services")) {
            Node serviceLogNode;
            Node serviceFolder = session.getRootNode().getNode("exo:services");
            Node serviceNode = serviceFolder.hasNode(serviceName) ? serviceFolder.getNode(serviceName) : serviceFolder.addNode(serviceName, "nt:unstructured");
            String serviceLogName = serviceName + "_" + logType;
            Node node = serviceLogNode = serviceNode.hasNode(serviceLogName) ? serviceNode.getNode(serviceLogName) : serviceNode.addNode(serviceLogName, "nt:file");
            if (serviceLogNode.hasNode("jcr:content")) {
                serviceLogContentNode = serviceLogNode.getNode("jcr:content");
            } else {
                serviceLogContentNode = serviceLogNode.addNode("jcr:content", "nt:resource");
                serviceLogContentNode.setProperty("jcr:encoding", "UTF-8");
                serviceLogContentNode.setProperty("jcr:mimeType", "text/plain");
                serviceLogContentNode.setProperty("jcr:data", "");
                serviceLogContentNode.setProperty("jcr:lastModified", new Date().getTime());
            }
        }
        session.save();
        return serviceLogContentNode;
    }
}

