/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.lock.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.services.cms.lock.impl.LockGroupsOrUsersPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockServiceImpl
implements LockService,
Startable {
    private List<String> settingLockList = new ArrayList<String>();
    private List<String> preSettingLockList = new ArrayList<String>();
    private List<LockGroupsOrUsersPlugin> lockGroupsOrUsersPlugin_ = new ArrayList<LockGroupsOrUsersPlugin>();
    private static final Log LOG = ExoLogger.getLogger((String)LockServiceImpl.class.getName());
    private HashMap<String, Map<String, String>> lockHolding = new HashMap();

    public LockServiceImpl(InitParams params) throws Exception {
    }

    @Override
    public void addLockGroupsOrUsersPlugin(ComponentPlugin plugin) {
        if (plugin instanceof LockGroupsOrUsersPlugin) {
            this.lockGroupsOrUsersPlugin_.add((LockGroupsOrUsersPlugin)plugin);
        }
    }

    @Override
    public List<String> getPreSettingLockList() {
        return this.preSettingLockList;
    }

    @Override
    public List<String> getAllGroupsOrUsersForLock() throws Exception {
        return this.settingLockList;
    }

    @Override
    public void addGroupsOrUsersForLock(String groupsOrUsers) throws Exception {
        if (!this.settingLockList.contains(groupsOrUsers)) {
            this.settingLockList.add(groupsOrUsers);
        }
    }

    @Override
    public void removeGroupsOrUsersForLock(String groupsOrUsers) throws Exception {
        if (this.settingLockList.contains(groupsOrUsers)) {
            this.settingLockList.remove(groupsOrUsers);
        }
    }

    @Override
    public HashMap<String, Map<String, String>> getLockHolding() {
        return this.lockHolding;
    }

    @Override
    public void putToLockHoding(String userId, Map<String, String> lockedNodesInfo) {
        this.lockHolding.put(userId, lockedNodesInfo);
    }

    @Override
    public Map<String, String> getLockInformation(String userId) {
        return this.lockHolding.get(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocksOfUser(String userId) {
        Map<String, String> lockedNodes;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Removing all locked nodes of user " + userId));
        }
        if ((lockedNodes = this.lockHolding.get(userId)) == null || lockedNodes.values().isEmpty()) {
            return;
        }
        try {
            Iterator<String> iter = lockedNodes.keySet().iterator();
            while (iter.hasNext()) {
                try {
                    String key = iter.next();
                    String[] temp = key.split(":/:");
                    String nodePath = temp[1];
                    String[] location = temp[0].split("/::/");
                    String workspaceName = location[1];
                    Session session = sessionProvider.getSession(workspaceName, repositoryService.getCurrentRepository());
                    String lockToken = lockedNodes.get(key);
                    session.addLockToken(lockToken);
                    Node node = (Node)session.getItem(nodePath);
                    node.unlock();
                    node.removeMixin("mix:lockable");
                    node.save();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)"Error while unlocking the locked nodes", (Throwable)e);
                }
            }
            lockedNodes.clear();
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocks() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Clean all locked nodes in the system");
        }
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        try {
            String wsName = repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            Session session = sessionProvider.getSession(wsName, repositoryService.getCurrentRepository());
            String lockQueryStatement = "SELECT * from mix:lockable ORDER BY exo:dateCreated";
            QueryResult queryResult = session.getWorkspace().getQueryManager().createQuery(lockQueryStatement, "sql").execute();
            NodeIterator nodeIter = queryResult.getNodes();
            while (nodeIter.hasNext()) {
                Node lockedNode = nodeIter.nextNode();
                if (lockedNode.isLocked()) {
                    lockedNode.unlock();
                }
                lockedNode.removeMixin("mix:lockable");
                lockedNode.save();
            }
        }
        catch (RepositoryException re) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error while unlocking the locked nodes", (Throwable)re);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    public void start() {
        this.lockHolding.clear();
        this.settingLockList.clear();
        this.preSettingLockList.clear();
        this.removeLocks();
        for (LockGroupsOrUsersPlugin plugin : this.lockGroupsOrUsersPlugin_) {
            try {
                this.settingLockList.addAll(plugin.initGroupsOrUsers());
                this.preSettingLockList.addAll(plugin.initGroupsOrUsers());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)"can not init lock groups or users: ", (Throwable)e);
            }
        }
    }

    public void stop() {
        this.lockHolding.clear();
        this.settingLockList.clear();
        this.preSettingLockList.clear();
    }
}

