/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.drives;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;

public class UIViewsInputSet
extends UIFormInputSet {
    public UIViewsInputSet(String name) throws Exception {
        super(name);
    }

    public String getViewsSelected() throws Exception {
        StringBuilder selectedView = new StringBuilder();
        List views_ = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getAllViews();
        for (ViewConfig view : views_) {
            String viewName = view.getName();
            boolean checked = this.getUIFormCheckBoxInput(viewName).isChecked();
            if (!checked) continue;
            if (selectedView.length() > 0) {
                selectedView.append(", ");
            }
            selectedView.append(viewName);
        }
        if (selectedView.length() < 1) {
            throw new MessageException(new ApplicationMessage("UIDriveForm.msg.drive-views-invalid", null, 1));
        }
        return selectedView.toString();
    }

    private void clear() throws Exception {
        List views_ = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getAllViews();
        Collections.sort(views_, new ViewComparator());
        for (ViewConfig view : views_) {
            String viewName = view.getName();
            if (this.getUIFormCheckBoxInput(viewName) != null) {
                this.getUIFormCheckBoxInput(viewName).setChecked(false);
                continue;
            }
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(viewName, viewName, null));
        }
    }

    public void update(DriveData drive) throws Exception {
        String[] array;
        this.clear();
        if (drive == null) {
            return;
        }
        String views = drive.getViews();
        for (String view : array = views.split(",")) {
            this.getUIFormCheckBoxInput(view.trim()).setChecked(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewComparator
    implements Comparator<ViewConfig> {
        @Override
        public int compare(ViewConfig v1, ViewConfig v2) throws ClassCastException {
            String displayName2;
            String displayName1;
            WebuiRequestContext webReqContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            try {
                displayName1 = webReqContext.getApplicationResourceBundle().getString("UIDriveForm.label." + v1.getName());
            }
            catch (MissingResourceException mre) {
                displayName1 = v1.getName();
            }
            try {
                displayName2 = webReqContext.getApplicationResourceBundle().getString("UIDriveForm.label." + v2.getName());
            }
            catch (MissingResourceException mre) {
                displayName2 = v2.getName();
            }
            return displayName1.compareToIgnoreCase(displayName2);
        }
    }
}

