/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.admin.views.UIViewContainer;
import org.exoplatform.ecm.webui.component.admin.views.UIViewForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewFormTabPane;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="classpath:groovy/ecm/webui/form/UIFormInputSetWithAction.gtmpl")
public class UITabForm
extends UIFormInputSetWithAction {
    public static final String FIELD_NAME = "tabName";
    private List<?> buttons_;

    public UITabForm(String name) throws Exception {
        super(name);
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null));
        ManageViewService vservice_ = (ManageViewService)this.getApplicationComponent(ManageViewService.class);
        this.buttons_ = vservice_.getButtons();
        for (Object bt : this.buttons_) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(this.getButtonName(bt), "", null));
        }
        this.setActions(new String[]{"AddTab", "Reset", "BackViewForm"}, null);
    }

    private String getButtonName(Object bt) {
        String button = (String)bt;
        return button.substring(0, 1).toLowerCase() + button.substring(1);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public void refresh(boolean isEditable) throws Exception {
        this.getUIStringInput(FIELD_NAME).setEditable(isEditable).setValue(null);
        for (Object bt : this.buttons_) {
            this.getUIFormCheckBoxInput(this.getButtonName(bt)).setChecked(false).setEditable(isEditable);
        }
        if (isEditable) {
            this.setActions(new String[]{"AddTab", "Reset", "BackViewForm"}, null);
        }
    }

    public void update(ViewConfig.Tab tab, boolean isView) throws Exception {
        String[] buttonArray;
        this.refresh(!isView);
        if (tab == null) {
            return;
        }
        this.getUIStringInput(FIELD_NAME).setEditable(false).setValue((Object)tab.getTabName());
        String buttonsProperty = tab.getButtons();
        for (String bt : buttonArray = StringUtils.split((String)buttonsProperty, (String)";")) {
            UIFormCheckBoxInput cbInput = this.getUIFormCheckBoxInput(bt.trim());
            if (cbInput == null) continue;
            cbInput.setChecked(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddTabActionListener
    extends EventListener<UIViewFormTabPane> {
        public void execute(Event<UIViewFormTabPane> event) throws Exception {
            String[] arrFilterChar;
            UIViewFormTabPane viewFormTabPane = (UIViewFormTabPane)((Object)event.getSource());
            UIViewForm uiViewForm = (UIViewForm)viewFormTabPane.getChild(UIViewForm.class);
            UITabForm uiTabForm = (UITabForm)viewFormTabPane.getChild(UITabForm.class);
            String tabName = (String)uiTabForm.getUIStringInput(UITabForm.FIELD_NAME).getValue();
            UIApplication uiApp = (UIApplication)((UIViewFormTabPane)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
            if (tabName == null || tabName.trim().length() == 0) {
                viewFormTabPane.setSelectedTab(uiTabForm.getId());
                uiApp.addMessage(new ApplicationMessage("UITabForm.msg.tab-name-error", null, 1));
                return;
            }
            for (String filterChar : arrFilterChar = new String[]{"&", "$", "@", ",", ":", "]", "[", "*", "%", "!"}) {
                if (tabName.indexOf(filterChar) <= -1) continue;
                uiApp.addMessage(new ApplicationMessage("UITabForm.msg.fileName-invalid", null, 1));
                return;
            }
            StringBuilder selectedButton = new StringBuilder();
            boolean isSelected = false;
            for (Object bt : uiTabForm.buttons_) {
                String button = uiTabForm.getButtonName(bt);
                if (!uiTabForm.getUIFormCheckBoxInput(button).isChecked()) continue;
                isSelected = true;
                if (selectedButton.length() > 0) {
                    selectedButton.append(";").append(button);
                    continue;
                }
                selectedButton.append(button);
            }
            if (!isSelected) {
                viewFormTabPane.setSelectedTab(uiTabForm.getId());
                uiApp.addMessage(new ApplicationMessage("UITabForm.msg.button-select-error", null, 1));
                return;
            }
            uiViewForm.setRendered(true);
            uiTabForm.setRendered(false);
            ((UIFormStringInput)uiTabForm.getChildById(UITabForm.FIELD_NAME)).getValidators().clear();
            ((UIFormStringInput)uiViewForm.getChildById("viewName")).setValue((Object)uiViewForm.getViewName());
            ((UIFormStringInput)uiViewForm.getChildById("permission")).setValue((Object)uiViewForm.getPermission());
            viewFormTabPane.setSelectedTab(uiViewForm.getId());
            uiViewForm.addTab(tabName, selectedButton.toString());
            uiViewForm.update(null, false, null);
            UIViewContainer uiViewContainer = (UIViewContainer)uiTabForm.getAncestorOfType(UIViewContainer.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }
}

