/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.ide.download.NodeTypeUtil;

public class ZipUtils {
    private static final String DEFAULT_FILE_NODE_TYPE = "nt:file";
    public static final String DEFAULT_JCR_CONTENT_NODE_TYPE = "nt:resource";

    public static void unzip(Session session, InputStream inputStream, String parentFolderPath) throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException, IOException, IllegalArgumentException {
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(inputStream);
        ZipEntry zipentry = zin.getNextEntry();
        if (zipentry == null) {
            throw new IllegalArgumentException("Zip archive is empty");
        }
        while (zipentry != null) {
            String entryName = zipentry.getName();
            if (zipentry.isDirectory()) {
                ZipUtils.putFolder(session, parentFolderPath, entryName);
            } else {
                int bytesRead;
                ByteArrayOutputStream outS = new ByteArrayOutputStream();
                while ((bytesRead = zin.read(buf, 0, 1024)) > -1) {
                    outS.write(buf, 0, bytesRead);
                }
                ByteArrayInputStream data = new ByteArrayInputStream(outS.toByteArray());
                outS.close();
                MimeTypeResolver resolver = new MimeTypeResolver();
                ZipUtils.putFile(session, parentFolderPath, entryName, data, resolver.getMimeType(entryName), null, null);
            }
            zin.closeEntry();
            zipentry = zin.getNextEntry();
        }
        zin.close();
        session.save();
    }

    public static void writeZip(OutputStream outputStream, Node nodeToPack) throws IOException {
        String pathPrefix = null;
        ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(outputStream);
        zipOut.setEncoding("UTF-8");
        try {
            pathPrefix = nodeToPack.getPath();
            pathPrefix = pathPrefix.substring(0, pathPrefix.length() - nodeToPack.getName().length());
            ZipUtils.zipNodeContent(nodeToPack, zipOut, pathPrefix);
        }
        catch (RepositoryException exc) {
            throw new IOException(exc.getMessage());
        }
        zipOut.close();
    }

    private static void zipNodeContent(Node node, ZipArchiveOutputStream zipOutputStream, String pathPrefix) throws RepositoryException, IOException {
        String path = node.getPath();
        path = path.substring(pathPrefix.length());
        if (NodeTypeUtil.isFile(node)) {
            InputStream inputStream = node.getNode("jcr:content").getProperty("jcr:data").getStream();
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(path);
            zipOutputStream.putArchiveEntry((ArchiveEntry)zipEntry);
            ZipUtils.flushJCRData(inputStream, zipOutputStream);
            zipOutputStream.closeArchiveEntry();
        } else {
            if (!"/".equals(node.getPath())) {
                path = path + "/";
                ZipArchiveEntry zipEntry = new ZipArchiveEntry(path);
                zipOutputStream.putArchiveEntry((ArchiveEntry)zipEntry);
                zipOutputStream.closeArchiveEntry();
            }
            NodeIterator nodeIterator = node.getNodes();
            while (nodeIterator.hasNext()) {
                Node child = nodeIterator.nextNode();
                ZipUtils.zipNodeContent(child, zipOutputStream, pathPrefix);
            }
        }
    }

    private static void flushJCRData(InputStream inputStream, ZipArchiveOutputStream zipOutputStream) throws IOException {
        int readed;
        byte[] buffer = new byte[4096];
        while ((readed = inputStream.read(buffer)) >= 0) {
            zipOutputStream.write(buffer, 0, readed);
        }
    }

    private static void putFolder(Session session, String parentFolderPath, String folderPath) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        Node base = parentFolderPath != null ? session.getRootNode().getNode(parentFolderPath) : session.getRootNode();
        base.addNode(folderPath, "nt:folder");
    }

    public static void putFile(Session session, String resourcePath, String filePath, InputStream data, String mimeType, String fileNodeType, String jcrContentNodeType) throws PathNotFoundException, RepositoryException {
        Node base = resourcePath != null ? session.getRootNode().getNode(resourcePath) : session.getRootNode();
        if (fileNodeType == null) {
            fileNodeType = DEFAULT_FILE_NODE_TYPE;
        }
        if (jcrContentNodeType == null) {
            jcrContentNodeType = DEFAULT_JCR_CONTENT_NODE_TYPE;
        }
        base = base.addNode(filePath, fileNodeType);
        base = base.addNode("jcr:content", jcrContentNodeType);
        base.setProperty("jcr:data", data);
        base.setProperty("jcr:lastModified", Calendar.getInstance());
        base.setProperty("jcr:mimeType", mimeType);
    }
}

