/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.organization.integration;

import javax.jcr.Session;
import org.exoplatform.platform.organization.integration.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;

public class NewGroupListener
extends GroupEventListener {
    private RepositoryService repositoryService;
    private DataDistributionManager dataDistributionManager;

    public NewGroupListener(DataDistributionManager dataDistributionManager, RepositoryService repositoryService) throws Exception {
        this.repositoryService = repositoryService;
        this.dataDistributionManager = dataDistributionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(Group group, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (!Util.hasGroupFolder(this.dataDistributionManager, session, group.getId())) {
                Util.createGroupFolder(this.dataDistributionManager, session, group.getId());
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(Group group) throws Exception {
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (Util.hasGroupFolder(this.dataDistributionManager, session, group.getId())) {
                Util.deleteGroupFolder(this.dataDistributionManager, session, group.getId());
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

