/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.organization.integration;

import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.platform.organization.integration.EventType;
import org.exoplatform.platform.organization.integration.OrganizationIntegrationService;
import org.exoplatform.platform.organization.integration.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.OrganizationService;

public class NewMembershipListener
extends MembershipEventListener {
    private RepositoryService repositoryService;
    private DataDistributionManager dataDistributionManager;
    private OrganizationIntegrationService organizationIntegrationService;
    private OrganizationService organizationService;

    public NewMembershipListener(DataDistributionManager dataDistributionManager, RepositoryService repositoryService) throws Exception {
        this.repositoryService = repositoryService;
        this.dataDistributionManager = dataDistributionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(Membership m, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (!Util.hasMembershipFolder(this.dataDistributionManager, session, m)) {
                if (!Util.hasGroupFolder(this.dataDistributionManager, session, m.getGroupId())) {
                    this.getOrganizationIntegrationService().syncGroup(m.getGroupId(), EventType.ADDED.toString());
                    if (this.getOrganizationService() instanceof ComponentRequestLifecycle) {
                        ((ComponentRequestLifecycle)this.organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
                    }
                }
                Util.createMembershipFolder(this.dataDistributionManager, session, m);
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(Membership m) throws Exception {
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (Util.hasMembershipFolder(this.dataDistributionManager, session, m)) {
                Util.deleteMembershipFolder(this.dataDistributionManager, session, m);
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private OrganizationIntegrationService getOrganizationIntegrationService() {
        if (this.organizationIntegrationService == null) {
            this.organizationIntegrationService = (OrganizationIntegrationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationIntegrationService.class);
        }
        return this.organizationIntegrationService;
    }

    private OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
        }
        return this.organizationService;
    }
}

