/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.organization.integration;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.impl.MembershipImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String MEMBERSHIPS_LIST_NODE_NAME = "list";
    public static final String SPECIAL_CHARACTER_REPLACEMENT = "___";
    public static final String MEMBERSHIP_SEPARATOR = "---";
    public static final String ORGANIZATION_INITIALIZATIONS = "integration_data";
    public static final String USERS_FOLDER = "usersData";
    public static final String GROUPS_FOLDER = "groupsData";
    public static final String MEMBERSHIPS_FOLDER = "membershipsData";
    public static final String PROFILES_FOLDER = "profilesData";
    public static String WORKSPACE = "collaboration";
    public static String HOME_PATH = "/";
    public static XStream xstreamList_ = null;

    public static void init(Session session) throws Exception {
        Node homePathNode = null;
        try {
            homePathNode = (Node)session.getItem(HOME_PATH);
        }
        catch (PathNotFoundException e) {
            homePathNode = Util.createFolder(session.getRootNode(), HOME_PATH);
        }
        Node organizationInitializersHomePathNode = null;
        organizationInitializersHomePathNode = !homePathNode.hasNode(ORGANIZATION_INITIALIZATIONS) ? Util.createFolder(homePathNode, ORGANIZATION_INITIALIZATIONS) : homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        if (!organizationInitializersHomePathNode.hasNode(USERS_FOLDER)) {
            Node usersNode = Util.createFolder(organizationInitializersHomePathNode, USERS_FOLDER);
            Util.saveListActivation(usersNode, new HashSet<String>(), true);
        }
        if (!organizationInitializersHomePathNode.hasNode(GROUPS_FOLDER)) {
            Node groupsNode = Util.createFolder(organizationInitializersHomePathNode, GROUPS_FOLDER);
            Util.saveListActivation(groupsNode, new HashSet<String>(), true);
        }
        if (!organizationInitializersHomePathNode.hasNode(MEMBERSHIPS_FOLDER)) {
            Util.createFolder(organizationInitializersHomePathNode, MEMBERSHIPS_FOLDER);
        }
        if (!organizationInitializersHomePathNode.hasNode(PROFILES_FOLDER)) {
            Util.createFolder(organizationInitializersHomePathNode, PROFILES_FOLDER);
        }
        session.save();
    }

    public static Node getUsersFolder(Session session) throws Exception {
        Node organizationInitializersHomePathNode = null;
        try {
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        catch (Exception e) {
            Util.init(session);
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        return organizationInitializersHomePathNode.getNode(USERS_FOLDER);
    }

    public static Node getGroupsFolder(Session session) throws Exception {
        Node organizationInitializersHomePathNode = null;
        try {
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        catch (Exception e) {
            Util.init(session);
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        return organizationInitializersHomePathNode.getNode(GROUPS_FOLDER);
    }

    public static Node getMembershipsFolder(Session session) throws Exception {
        Node organizationInitializersHomePathNode = null;
        try {
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        catch (Exception e) {
            Util.init(session);
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        return organizationInitializersHomePathNode.getNode(MEMBERSHIPS_FOLDER);
    }

    public static Node getProfilesFolder(Session session) throws Exception {
        Node organizationInitializersHomePathNode = null;
        try {
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        catch (Exception e) {
            Util.init(session);
            Node homePathNode = (Node)session.getItem(HOME_PATH);
            organizationInitializersHomePathNode = homePathNode.getNode(ORGANIZATION_INITIALIZATIONS);
        }
        return organizationInitializersHomePathNode.getNode(PROFILES_FOLDER);
    }

    public static boolean hasUserFolder(DataDistributionManager distributionManager, Session session, String username) throws RepositoryException, Exception {
        try {
            distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).getDataNode(Util.getUsersFolder(session), username);
        }
        catch (PathNotFoundException exception) {
            return false;
        }
        return true;
    }

    public static boolean hasProfileFolder(DataDistributionManager distributionManager, Session session, String username) throws RepositoryException, Exception {
        try {
            distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).getDataNode(Util.getProfilesFolder(session), username);
        }
        catch (PathNotFoundException exception) {
            return false;
        }
        return true;
    }

    public static boolean hasMembershipFolder(DataDistributionManager distributionManager, Session session, Membership membership) throws RepositoryException, Exception {
        try {
            String dataId = Util.getMembershipFolderName(membership);
            distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).getDataNode(Util.getMembershipsFolder(session), dataId);
        }
        catch (PathNotFoundException exception) {
            return false;
        }
        return true;
    }

    public static boolean hasGroupFolder(DataDistributionManager distributionManager, Session session, String groupId) throws RepositoryException, Exception {
        try {
            distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).getDataNode(Util.getGroupsFolder(session), Util.getGroupFolderName(groupId));
        }
        catch (PathNotFoundException exception) {
            return false;
        }
        return true;
    }

    public static void createUserFolder(DataDistributionManager distributionManager, Session session, String username) throws Exception {
        Node usersNode = Util.getUsersFolder(session);
        Set<String> users = Util.getListActivation(usersNode);
        users.add(username);
        Util.saveListActivation(usersNode, users, false);
        Node userNode = distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).getOrCreateDataNode(usersNode, username);
        Util.saveListActivation(userNode, new HashSet<String>(), true);
        session.save();
    }

    public static void createProfileFolder(DataDistributionManager distributionManager, Session session, String username) throws Exception {
        distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).getOrCreateDataNode(Util.getProfilesFolder(session), username);
    }

    public static void createMembershipFolder(DataDistributionManager distributionManager, Session session, Membership membership) throws Exception {
        String dataId = Util.getMembershipFolderName(membership);
        distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).getOrCreateDataNode(Util.getMembershipsFolder(session), dataId);
        String membershipId = Util.computeMembershipId(membership);
        Node groupNode = Util.getGroupNode(distributionManager, session, membership.getGroupId());
        Set<String> groupMembershipList = Util.getListActivation(groupNode);
        groupMembershipList.add(membershipId);
        Util.saveListActivation(groupNode, groupMembershipList, false);
        Node userNode = Util.getUserNode(distributionManager, session, membership.getUserName());
        Set<String> userMembershipList = Util.getListActivation(userNode);
        userMembershipList.add(membershipId);
        Util.saveListActivation(userNode, userMembershipList, false);
        session.save();
    }

    public static void createGroupFolder(DataDistributionManager distributionManager, Session session, String groupId) throws Exception {
        Node groupsNode = Util.getGroupsFolder(session);
        Set<String> groups = Util.getListActivation(groupsNode);
        groups.add(groupId);
        Util.saveListActivation(groupsNode, groups, false);
        Node groupNode = distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).getOrCreateDataNode(groupsNode, Util.getGroupFolderName(groupId));
        Util.saveListActivation(groupNode, new HashSet<String>(), true);
        session.save();
    }

    public static Node getUserNode(DataDistributionManager distributionManager, Session session, String username) throws Exception {
        return distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).getDataNode(Util.getUsersFolder(session), username);
    }

    public static Node getGroupNode(DataDistributionManager distributionManager, Session session, String groupId) throws Exception {
        return distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).getDataNode(Util.getGroupsFolder(session), Util.getGroupFolderName(groupId));
    }

    public static void deleteUserFolder(DataDistributionManager distributionManager, Session session, String username) throws Exception {
        Node usersNode = Util.getUsersFolder(session);
        Set<String> users = Util.getListActivation(usersNode);
        users.remove(username);
        Util.saveListActivation(usersNode, users, false);
        distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).removeDataNode(usersNode, username);
    }

    public static void deleteProfileFolder(DataDistributionManager distributionManager, Session session, String username) throws Exception {
        distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).removeDataNode(Util.getProfilesFolder(session), username);
    }

    public static void deleteGroupFolder(DataDistributionManager distributionManager, Session session, String groupId) throws Exception {
        Node groupsNode = Util.getGroupsFolder(session);
        Set<String> groups = Util.getListActivation(groupsNode);
        groups.remove(groupId);
        Util.saveListActivation(groupsNode, groups, false);
        distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).removeDataNode(groupsNode, Util.getGroupFolderName(groupId));
    }

    public static void deleteMembershipFolder(DataDistributionManager distributionManager, Session session, Membership membership) throws Exception {
        String dataId = Util.getMembershipFolderName(membership);
        distributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED).removeDataNode(Util.getMembershipsFolder(session), dataId);
        String membershipId = Util.computeMembershipId(membership);
        if (Util.hasGroupFolder(distributionManager, session, membership.getGroupId())) {
            Node groupNode = Util.getGroupNode(distributionManager, session, membership.getGroupId());
            Set<String> groupMembershipList = Util.getListActivation(groupNode);
            groupMembershipList.remove(membershipId);
            Util.saveListActivation(groupNode, groupMembershipList, false);
        }
        if (Util.hasUserFolder(distributionManager, session, membership.getUserName())) {
            Node userNode = Util.getUserNode(distributionManager, session, membership.getUserName());
            Set<String> userMembershipList = Util.getListActivation(userNode);
            userMembershipList.remove(membershipId);
            Util.saveListActivation(userNode, userMembershipList, false);
        }
        session.save();
    }

    public static Set<String> getActivatedUsers(Session session) throws Exception {
        return Util.getListActivation(Util.getUsersFolder(session));
    }

    public static Set<String> getActivatedGroups(Session session) throws Exception {
        return Util.getListActivation(Util.getGroupsFolder(session));
    }

    public static List<Group> getActivatedChildrenGroup(Session session, String parentGroupId) throws Exception {
        ArrayList<Group> activatedChildrenGroups = new ArrayList<Group>();
        Set<String> activatedGroups = Util.getActivatedGroups(session);
        for (String groupId : activatedGroups) {
            if (!groupId.startsWith(parentGroupId) || groupId.equals(parentGroupId)) continue;
            GroupImpl group = new GroupImpl();
            group.setId(groupId);
            group.setGroupName(groupId);
            activatedChildrenGroups.add((Group)group);
        }
        return activatedChildrenGroups;
    }

    public static List<Membership> getActivatedMembershipsRelatedToGroup(DataDistributionManager distributionManager, Session session, String groupId) throws Exception {
        Set<String> memberships = Util.getListActivation(Util.getGroupNode(distributionManager, session, groupId));
        ArrayList<Membership> activatedMemberships = new ArrayList<Membership>();
        for (String membershipId : memberships) {
            activatedMemberships.add(Util.computeMembershipFromId(membershipId));
        }
        return activatedMemberships;
    }

    public static List<Membership> getActivatedMembershipsRelatedToUser(DataDistributionManager distributionManager, Session session, String username) throws Exception {
        Set<String> memberships = Util.getListActivation(Util.getUserNode(distributionManager, session, username));
        ArrayList<Membership> activatedMemberships = new ArrayList<Membership>();
        for (String membershipId : memberships) {
            activatedMemberships.add(Util.computeMembershipFromId(membershipId));
        }
        return activatedMemberships;
    }

    private static Membership computeMembershipFromId(String membershipId) {
        String[] membershipElements = membershipId.split(":");
        String membershipType = membershipElements[0];
        String username = membershipElements[1];
        String groupId = membershipElements[2];
        MembershipImpl membership = new MembershipImpl();
        membership.setGroupId(groupId);
        membership.setMembershipType(membershipType);
        membership.setUserName(username);
        membership.setId(membershipId);
        return membership;
    }

    public static String computeMembershipId(Membership membership) {
        StringBuffer id = new StringBuffer();
        if (membership.getMembershipType() != null) {
            id.append(membership.getMembershipType());
        }
        id.append(":");
        if (membership.getUserName() != null) {
            id.append(membership.getUserName());
        }
        id.append(":");
        if (membership.getGroupId() != null) {
            id.append(membership.getGroupId());
        }
        return id.toString();
    }

    private static Node createFolder(Node parentNode, String name) throws Exception {
        Node orgIntServNode = parentNode.addNode(name, "nt:unstructured");
        parentNode.save();
        if (orgIntServNode.canAddMixin("exo:hiddenable")) {
            orgIntServNode.addMixin("exo:hiddenable");
        }
        orgIntServNode.save();
        return orgIntServNode;
    }

    private static Set<String> getListActivation(Node parentNode) throws Exception {
        String xml = parentNode.getProperty("list/jcr:data").getString();
        return (Set)xstreamList_.fromXML(xml);
    }

    private static synchronized void saveListActivation(Node parentNode, Set<String> list, boolean isNew) throws Exception {
        String content = xstreamList_.toXML(list);
        Node fileNode = null;
        fileNode = isNew ? parentNode.addNode(MEMBERSHIPS_LIST_NODE_NAME, "nt:resource") : parentNode.getNode(MEMBERSHIPS_LIST_NODE_NAME);
        fileNode.setProperty("jcr:data", content);
        fileNode.setProperty("jcr:mimeType", "text/xml");
        fileNode.setProperty("jcr:lastModified", Calendar.getInstance());
        parentNode.save();
    }

    private static String getMembershipFolderName(Membership membership) {
        String dataId = membership.getId();
        if (dataId == null || dataId.isEmpty()) {
            dataId = membership.getUserName() + membership.getGroupId() + membership.getMembershipType();
        }
        return "" + dataId.hashCode();
    }

    private static String getGroupFolderName(String groupId) {
        return "" + groupId.hashCode();
    }

    static {
        xstreamList_ = new XStream((HierarchicalStreamDriver)new XppDriver());
        xstreamList_.alias(MEMBERSHIPS_LIST_NODE_NAME, HashSet.class);
    }
}

