/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy;

import java.io.InputStream;
import java.security.Principal;
import java.util.Collections;
import javax.annotation.security.RolesAllowed;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ide.groovy.util.ClassPathFileNotFoundException;
import org.exoplatform.ide.groovy.util.DependentResources;
import org.exoplatform.ide.groovy.util.GroovyScriptServiceUtil;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.jcr.ext.resource.jcr.Handler;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestLoader;
import org.exoplatform.services.jcr.ext.script.groovy.NodeScriptKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.ext.groovy.GroovyJaxrsPublisher;
import org.exoplatform.services.rest.ext.groovy.ResourceId;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.impl.ResourcePublicationException;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.script.groovy.GroovyScriptInstantiator;

@Path(value="/ide/groovy/")
public class GroovyScriptService
extends GroovyScript2RestLoader {
    private static final Log LOG = ExoLogger.getLogger(GroovyScriptService.class);
    public static final String DEVELOPER_ID = "ide.developer.id";
    public static final String GROOVY_CLASSPATH = ".groovyclasspath";
    int resourceLiveTime = 900000;

    public GroovyScriptService(ResourceBinder binder, GroovyScriptInstantiator groovyScriptInstantiator, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, ConfigurationManager configurationManager, Handler jcrUrlHandler, InitParams params) {
        super(binder, groovyScriptInstantiator, repositoryService, sessionProviderService, configurationManager, jcrUrlHandler, params);
    }

    public GroovyScriptService(ResourceBinder binder, GroovyScriptInstantiator groovyScriptInstantiator, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, ConfigurationManager configurationManager, RegistryService registryService, GroovyJaxrsPublisher groovyPublisher, Handler jcrUrlHandler, InitParams params) {
        super(binder, groovyScriptInstantiator, repositoryService, sessionProviderService, configurationManager, registryService, groovyPublisher, jcrUrlHandler, params);
    }

    public GroovyScriptService(ResourceBinder binder, GroovyScriptInstantiator groovyScriptInstantiator, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, ConfigurationManager configurationManager, RegistryService registryService, Handler jcrUrlHandler, InitParams params) {
        super(binder, groovyScriptInstantiator, repositoryService, sessionProviderService, configurationManager, registryService, jcrUrlHandler, params);
    }

    @POST
    @Path(value="/validate-script")
    public Response validate(@Context UriInfo uriInfo, @HeaderParam(value="location") String location, InputStream inputStream) {
        String name = location != null && location.length() > 0 ? location.substring(location.lastIndexOf("/") + 1) : "";
        DependentResources dependentResources = GroovyScriptServiceUtil.getDependentResource(location, uriInfo.getBaseUri().toASCIIString(), this.repositoryService, this.sessionProviderService);
        if (dependentResources != null) {
            return super.validateScript(name, inputStream, dependentResources.getFolderSources(), dependentResources.getFileSources());
        }
        return super.validateScript(name, inputStream, Collections.emptyList(), Collections.emptyList());
    }

    @GET
    @Path(value="/classpath-location")
    @Produces(value={"text/plain"})
    public String getClassPathLocation(@Context UriInfo uriInfo, @HeaderParam(value="location") String location) {
        String baseUri = uriInfo.getBaseUri().toASCIIString();
        String[] jcrLocation = GroovyScriptServiceUtil.parseJcrLocation(baseUri, location);
        try {
            Session session = GroovyScriptServiceUtil.getSession(this.repositoryService, (SessionProviderService)this.sessionProviderService, jcrLocation[0], jcrLocation[1] + "/" + jcrLocation[2]);
            Node rootNode = session.getRootNode();
            Node node = rootNode.getNode(jcrLocation[2]);
            Node classpathNode = this.findClassPathNode(node);
            if (classpathNode != null) {
                String classpathLocation = baseUri + "/jcr/" + jcrLocation[0] + "/" + jcrLocation[1];
                classpathLocation = classpathLocation + (classpathNode.getPath().startsWith("/") ? classpathNode.getPath() : "/" + classpathNode.getPath());
                return classpathLocation;
            }
            throw new ClassPathFileNotFoundException("Groovy classpath file not found.");
        }
        catch (RepositoryException e) {
            throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 500));
        }
        catch (RepositoryConfigurationException e) {
            throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 500));
        }
        catch (ClassPathFileNotFoundException e) {
            throw new WebApplicationException((Throwable)e, this.createErrorResponse(e, 404));
        }
    }

    private Node findClassPathNode(Node node) throws RepositoryException {
        if (node == null) {
            return null;
        }
        NodeIterator nodeIterator = node.getNodes("*.groovyclasspath");
        while (nodeIterator.hasNext()) {
            Node childNode = nodeIterator.nextNode();
            if (!GROOVY_CLASSPATH.equals(childNode.getName())) continue;
            return childNode;
        }
        try {
            Node parentNode = node.getParent();
            return this.findClassPathNode(parentNode);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (AccessDeniedException e) {
            return null;
        }
    }

    @POST
    @Path(value="/deploy-sandbox")
    @RolesAllowed(value={"developers"})
    public Response deployInSandbox(@Context UriInfo uriInfo, @HeaderParam(value="location") String location, @Context SecurityContext security, MultivaluedMap<String, String> properties) {
        return this.sandboxLoader(uriInfo, location, true, security, properties);
    }

    @POST
    @Path(value="/undeploy-sandbox")
    @RolesAllowed(value={"developers"})
    public Response undeployFromSandox(@Context UriInfo uriInfo, @HeaderParam(value="location") String location, @Context SecurityContext security, MultivaluedMap<String, String> properties) {
        return this.sandboxLoader(uriInfo, location, false, security, properties);
    }

    @POST
    @Path(value="/deploy")
    @RolesAllowed(value={"administrators"})
    public Response deploy(@Context UriInfo uriInfo, @HeaderParam(value="location") String location, MultivaluedMap<String, String> properties) {
        String[] jcrLocation = GroovyScriptServiceUtil.parseJcrLocation(uriInfo.getBaseUri().toASCIIString(), location);
        if (jcrLocation == null) {
            return Response.status((int)404).entity((Object)(location + " not found. ")).type("text/plain").build();
        }
        DependentResources dependentResources = GroovyScriptServiceUtil.getDependentResource(location, uriInfo.getBaseUri().toASCIIString(), this.repositoryService, this.sessionProviderService);
        if (dependentResources != null) {
            return super.load(jcrLocation[0], jcrLocation[1], jcrLocation[2], true, dependentResources.getFolderSources(), dependentResources.getFileSources(), properties);
        }
        return super.load(jcrLocation[0], jcrLocation[1], jcrLocation[2], true, Collections.emptyList(), Collections.emptyList(), properties);
    }

    @POST
    @Path(value="/undeploy")
    @RolesAllowed(value={"administrators"})
    public Response undeploy(@Context UriInfo uriInfo, @HeaderParam(value="location") String location, MultivaluedMap<String, String> properties) {
        String[] jcrLocation = GroovyScriptServiceUtil.parseJcrLocation(uriInfo.getBaseUri().toASCIIString(), location);
        if (jcrLocation == null) {
            return Response.status((int)404).entity((Object)(location + " not found. ")).type("text/plain").build();
        }
        return super.load(jcrLocation[0], jcrLocation[1], jcrLocation[2], false, Collections.emptyList(), Collections.emptyList(), properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response sandboxLoader(UriInfo uriInfo, String location, boolean state, SecurityContext security, MultivaluedMap<String, String> properties) {
        Response response;
        String[] jcrLocation = GroovyScriptServiceUtil.parseJcrLocation(uriInfo.getBaseUri().toASCIIString(), location);
        if (jcrLocation == null) {
            return Response.status((int)404).entity((Object)(location + " not found. ")).type("text/plain").build();
        }
        String userId = null;
        Principal principal = security.getUserPrincipal();
        if (principal != null) {
            userId = principal.getName();
        }
        if (userId == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User principal not found.").type("text/plain").build();
        }
        Session ses = null;
        try {
            ses = this.sessionProviderService.getSessionProvider(null).getSession(jcrLocation[1], this.repositoryService.getRepository(jcrLocation[0]));
            Node script = ((Node)ses.getItem("/" + jcrLocation[2])).getNode("jcr:content");
            NodeScriptKey key = new NodeScriptKey(jcrLocation[0], jcrLocation[1], script);
            ObjectFactory resource = this.groovyPublisher.getResource((ResourceId)key);
            if (resource != null) {
                String developer = (String)((AbstractResourceDescriptor)resource.getObjectModel()).getProperties().getFirst((Object)DEVELOPER_ID);
                if (!userId.equals(developer)) {
                    Response response2 = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Access to not own resource forbidden. ").type("text/plain").build();
                    return response2;
                }
                this.groovyPublisher.unpublishResource((ResourceId)key);
            } else if (!state) {
                Response developer = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Can't remove resource " + jcrLocation[2] + ", not bound or has wrong mapping to the resource. ")).type("text/plain").build();
                return developer;
            }
            if (state) {
                if (properties == null) {
                    properties = new MultivaluedMapImpl();
                }
                properties.putSingle((Object)DEVELOPER_ID, (Object)userId);
                properties.putSingle((Object)"resource.expiration.date", (Object)Long.toString(System.currentTimeMillis() + (long)this.resourceLiveTime));
                DependentResources dependentResources = GroovyScriptServiceUtil.getDependentResource(location, uriInfo.getBaseUri().toASCIIString(), this.repositoryService, this.sessionProviderService);
                if (dependentResources != null) {
                    Response response3 = this.load(jcrLocation[0], jcrLocation[1], jcrLocation[2], true, dependentResources.getFolderSources(), dependentResources.getFileSources(), (MultivaluedMap)properties);
                    return response3;
                }
                Response response4 = this.load(jcrLocation[0], jcrLocation[1], jcrLocation[2], true, Collections.emptyList(), Collections.emptyList(), (MultivaluedMap)properties);
                return response4;
            }
            Response response5 = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            return response5;
        }
        catch (PathNotFoundException e) {
            String msg = "Path " + jcrLocation[2] + " does not exists";
            LOG.error((Object)msg);
            Response response6 = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)msg).type("text/plain").build();
            return response6;
        }
        catch (ResourcePublicationException e) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).type("text/plain").build();
            return response;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).type("text/plain").build();
            return response;
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    protected Response createErrorResponse(Throwable t, int status) {
        return Response.status((int)status).entity((Object)t.getMessage()).type("text/plain").build();
    }
}

