/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy;

import groovy.servlet.ServletBinding;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.groovy.control.CompilationFailedException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/ide/gtmpl")
public class GroovyTemplateService
implements ResourceContainer {
    private RepositoryService repositoryService;
    private ThreadLocalSessionProviderService sessionProviderService;
    private String WEBDAV_CONTEXT = "jcr";
    private TemplateEngine engine = new SimpleTemplateEngine();

    public GroovyTemplateService(RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    @POST
    @Path(value="/render-source")
    @Produces(value={"text/html"})
    @Consumes(value={"application/x-groovy+html"})
    public Response render(@Context ServletContext context, @Context HttpServletRequest request, @Context HttpServletResponse response, String gtmplSrc) throws CompilationFailedException, ClassNotFoundException, IOException {
        Template template = this.engine.createTemplate(gtmplSrc);
        ServletBinding binding = new ServletBinding(request, response, context);
        String render = template.make(binding.getVariables()).toString();
        return Response.ok((Object)render, (String)"text/html").build();
    }

    @GET
    @Path(value="/render")
    @Produces(value={"text/html"})
    public Response render(@Context ServletContext context, @Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam(value="url") String gtmplUrl) throws CompilationFailedException, ClassNotFoundException, IOException, LoginException, NoSuchWorkspaceException, RepositoryException, RepositoryConfigurationException {
        InputStreamReader reader = new InputStreamReader(this.getGtmplContent(uriInfo.getBaseUri().toASCIIString(), gtmplUrl));
        Template template = this.engine.createTemplate((Reader)reader);
        ServletBinding binding = new ServletBinding(request, response, context);
        String render = template.make(binding.getVariables()).toString();
        return Response.ok((Object)render, (String)"text/html").build();
    }

    private InputStream getGtmplContent(String baseUri, String gtmplUrl) throws LoginException, NoSuchWorkspaceException, RepositoryException, RepositoryConfigurationException {
        baseUri = baseUri + "/" + this.WEBDAV_CONTEXT + "/";
        String[] elements = new String[3];
        String path = gtmplUrl.substring(baseUri.length());
        elements[0] = path.substring(0, path.indexOf(47));
        path = path.substring(path.indexOf(47) + 1);
        elements[1] = path.substring(0, path.indexOf(47));
        elements[2] = path.substring(path.indexOf(47) + 1);
        Session ses = this.sessionProviderService.getSessionProvider(null).getSession(elements[1], this.repositoryService.getRepository(elements[0]));
        Node script = ((Node)ses.getItem("/" + elements[2])).getNode("jcr:content");
        InputStream is = script.getProperty("jcr:data").getStream();
        return is;
    }
}

