/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy.codeassistant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.exoplatform.ide.groovy.JcrUtils;
import org.exoplatform.ide.groovy.codeassistant.FileFinder;
import org.exoplatform.ide.groovy.codeassistant.SaveClassInfoException;
import org.exoplatform.ide.groovy.codeassistant.bean.JarEntry;
import org.exoplatform.ide.groovy.codeassistant.bean.TypeInfo;
import org.exoplatform.ide.groovy.codeassistant.extractors.ClassNamesExtractor;
import org.exoplatform.ide.groovy.codeassistant.extractors.TypeInfoExtractor;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

@Path(value="/ide/class-info-storage")
public class ClassInfoStorage {
    private ThreadLocalSessionProviderService sessionProviderService;
    private RepositoryService repositoryService;
    private final String wsName;
    private static final Log LOG = ExoLogger.getLogger(ClassInfoStorage.class);

    public ClassInfoStorage(ThreadLocalSessionProviderService sessionProvider, RepositoryService repositoryService, String wsName, final List<JarEntry> jars, boolean runInThread) {
        this.sessionProviderService = sessionProvider;
        this.repositoryService = repositoryService;
        this.wsName = wsName;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    ClassInfoStorage.this.addClassesOnStartUp(jars);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.runTask(run, runInThread);
    }

    private void runTask(Runnable run, boolean runInThread) {
        if (runInThread) {
            new Thread(run, "ClassInfoStorage").start();
        } else {
            run.run();
        }
    }

    @POST
    @Path(value="/jar")
    public void addClassesFromJar(@QueryParam(value="jar-path") String jarPath, @QueryParam(value="package") String packageName) throws SaveClassInfoException {
        try {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            List<String> fqns = ClassNamesExtractor.getCompiledClassesFromJar(jarPath, packageName);
            for (String fqn : fqns) {
                this.putClass(classLoader, JcrUtils.getSession(this.repositoryService, this.sessionProviderService, this.wsName), fqn);
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveClassInfoException(500, e.getMessage());
        }
    }

    @POST
    @Path(value="/class")
    public void addClass(@QueryParam(value="fqn") String fqn) throws SaveClassInfoException {
        try {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            this.putClass(classLoader, JcrUtils.getSession(this.repositoryService, this.sessionProviderService, this.wsName), fqn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SaveClassInfoException(500, e.getMessage());
        }
    }

    @POST
    @Path(value="/java")
    public void addClassesFromJavaSource(@QueryParam(value="java-source-path") String javaSrcPath, @QueryParam(value="package") String packageName) throws SaveClassInfoException {
        try {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            List<String> fqns = ClassNamesExtractor.getSourceClassesFromJar(javaSrcPath, packageName);
            for (String fqn : fqns) {
                this.putClass(classLoader, JcrUtils.getSession(this.repositoryService, this.sessionProviderService, this.wsName), fqn);
            }
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveClassInfoException(500, e.getMessage());
        }
        catch (IncompatibleClassChangeError e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveClassInfoException(500, e.getMessage());
        }
        catch (JsonException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveClassInfoException(500, e.getMessage());
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveClassInfoException(500, e.getMessage());
        }
        catch (RepositoryConfigurationException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveClassInfoException(500, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveClassInfoException(500, e.getMessage());
        }
    }

    public void addClassesOnStartUp(List<JarEntry> jars) throws SaveClassInfoException {
        try {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            ManageableRepository repository = JcrUtils.getRepository(this.repositoryService);
            Session session = this.sessionProviderService.getSystemSessionProvider(null).getSession(this.wsName, repository);
            for (JarEntry entry : jars) {
                String path = entry.getJarPath();
                FileFinder fileFinder = new FileFinder(path);
                for (String jarFile : fileFinder.getFileList()) {
                    LOG.info((Object)("Load ClassInfo from jar -" + jarFile));
                    ArrayList<String> fqns = new ArrayList<String>();
                    if (entry.getIncludePkgs() == null || entry.getIncludePkgs().isEmpty()) {
                        fqns.addAll(ClassNamesExtractor.getCompiledClassesFromJar(jarFile));
                    } else {
                        for (String pkg : entry.getIncludePkgs()) {
                            LOG.info((Object)("Load ClassInfo from - " + pkg));
                            fqns.addAll(ClassNamesExtractor.getCompiledClassesFromJar(jarFile, pkg));
                        }
                    }
                    for (String fqn : fqns) {
                        try {
                            this.putClass(classLoader, session, fqn);
                        }
                        catch (RepositoryException e) {
                            LOG.warn((Object)e.getMessage());
                        }
                        catch (JsonException e) {
                            LOG.warn((Object)e.getMessage());
                        }
                        catch (ClassNotFoundException e) {
                            LOG.warn((Object)("Could not add class " + fqn));
                        }
                        catch (NoClassDefFoundError e) {
                            LOG.warn((Object)("Could not add class " + fqn));
                        }
                    }
                }
            }
            LOG.info((Object)"Class info load complete");
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveClassInfoException(500, e.getMessage());
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveClassInfoException(500, e.getMessage());
        }
        catch (IncompatibleClassChangeError e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveClassInfoException(500, e.getMessage());
        }
        catch (RepositoryConfigurationException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new SaveClassInfoException(500, e.getMessage());
        }
    }

    private void putClass(ClassLoader classLoader, Session session, String fqn) throws RepositoryException, ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, IncompatibleClassChangeError, ValueFormatException, JsonException, AccessDeniedException, InvalidItemStateException, ClassNotFoundException {
        if (!session.getRootNode().hasNode("classpath")) {
            Node node = session.getRootNode().addNode("classpath", "nt:folder");
        }
        Node base = session.getRootNode().getNode("classpath");
        String clazz = fqn;
        Class<?> cls = classLoader.loadClass(clazz);
        TypeInfo cd = TypeInfoExtractor.extract(cls);
        Node child = base;
        String[] seg = fqn.split("\\.");
        String path = new String();
        for (int i = 0; i < seg.length - 1; ++i) {
            child = !child.hasNode(path = path + seg[i]) ? child.addNode(path, "nt:folder") : child.getNode(path);
            path = path + ".";
        }
        if (!child.hasNode(clazz)) {
            child = child.addNode(clazz, "nt:file");
            child = child.addNode("jcr:content", "exoide:classDescription");
            JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
            child.setProperty("jcr:data", jsonGenerator.createJsonObject((Object)cd).toString());
            child.setProperty("jcr:lastModified", Calendar.getInstance());
            child.setProperty("jcr:mimeType", "text/plain");
            child.setProperty("exoide:className", clazz.substring(clazz.lastIndexOf(".") + 1));
            child.setProperty("exoide:fqn", clazz);
            child.setProperty("exoide:type", cd.getType().toString());
            child.setProperty("exoide:modifieres", (long)cd.getModifiers().intValue());
        }
        session.save();
    }
}

