/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy.codeassistant.extractors;

import groovyjarjarantlr.RecognitionException;
import groovyjarjarantlr.TokenStreamException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.groovy.groovydoc.GroovyRootDoc;
import org.codehaus.groovy.tools.groovydoc.GroovyDocTool;

public class DocExtractor {
    private static String extPath;

    public static Map<String, GroovyRootDoc> extract(String javaArchSrcPath, String pkgPath) throws RecognitionException, TokenStreamException, IOException {
        String fs = System.getProperty("file.separator");
        String archName = javaArchSrcPath.substring(javaArchSrcPath.lastIndexOf(fs) + 1);
        String tmp = System.getProperty("java.io.tmpdir").endsWith(fs) ? System.getProperty("java.io.tmpdir") : System.getProperty("java.io.tmpdir") + fs;
        extPath = tmp + "source" + fs + archName + fs;
        HashMap<String, GroovyRootDoc> docs = new HashMap<String, GroovyRootDoc>();
        if (pkgPath != null) {
            pkgPath = pkgPath.replace(".", fs);
        }
        DocExtractor.unzip(javaArchSrcPath);
        Map<String, List<String>> pkgMap = DocExtractor.srcPkgMap(new File(extPath), new PkgFileFilter(pkgPath), true);
        Set<String> pkgs = pkgMap.keySet();
        for (String pkg : pkgs) {
            GroovyDocTool plainTool = new GroovyDocTool(new String[]{extPath + pkg});
            plainTool.add(pkgMap.get(pkg));
            docs.put(pkg.replace(fs, "."), plainTool.getRootDoc());
        }
        return docs;
    }

    public static Map<String, GroovyRootDoc> extract(String javaArchSrcPath) throws RecognitionException, TokenStreamException, IOException {
        return DocExtractor.extract(javaArchSrcPath, null);
    }

    private static void unzip(String zipPath) throws FileNotFoundException, IOException {
        new File(extPath).mkdirs();
        ZipFile zipFile = new ZipFile(zipPath);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                File file = new File(extPath + entry.getName());
                file.mkdir();
                continue;
            }
            DocExtractor.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(extPath + entry.getName())));
        }
        zipFile.close();
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    private static List<String> listFiles(File directory, FilenameFilter filter) {
        File[] entries;
        Vector<String> files = new Vector<String>();
        for (File entry : entries = directory.listFiles()) {
            if (filter != null && !filter.accept(directory, entry.getName())) continue;
            files.add(entry.getName());
        }
        return files;
    }

    public static Map<String, List<String>> srcPkgMap(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries = directory.listFiles();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (File entry : entries) {
            if (entry.isFile() && (filter == null || filter.accept(directory, entry.getName()))) {
                String p = entry.getParent();
                if (map.containsKey(p.substring(extPath.length()))) {
                    // empty if block
                }
                map.put(p.substring(extPath.length()), DocExtractor.listFiles(directory, filter));
            }
            if (!recurse || !entry.isDirectory()) continue;
            map.putAll(DocExtractor.srcPkgMap(entry, filter, recurse));
        }
        return map;
    }

    private static final class PkgFileFilter
    implements FilenameFilter {
        private final String pkg;

        public PkgFileFilter(String pkg) {
            this.pkg = pkg;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.pkg == null) {
                return name.endsWith(".java");
            }
            return dir.getPath().startsWith(extPath + this.pkg) && name.endsWith(".java");
        }
    }
}

