/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy.util;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.ide.groovy.util.GroovyClassPath;
import org.exoplatform.ide.groovy.util.GroovyClassPathEntry;

public class DependentResources {
    private List<String> fileSources = new ArrayList<String>();
    private List<String> folderSources = new ArrayList<String>();

    public DependentResources(String repositoryName, GroovyClassPath groovyClassPath) {
        String pathPrefix = "jcr://" + repositoryName;
        for (GroovyClassPathEntry entry : groovyClassPath.getEntries()) {
            String path;
            String string = path = entry.getPath().startsWith("/") ? pathPrefix + entry.getPath() : pathPrefix + "/" + entry.getPath();
            if (entry.getKind().equals("dir")) {
                this.folderSources.add(path);
                continue;
            }
            if (!entry.getKind().equals("file")) continue;
            this.fileSources.add(path);
        }
    }

    public List<String> getFileSources() {
        if (this.fileSources == null) {
            this.fileSources = new ArrayList<String>();
        }
        return this.fileSources;
    }

    public List<String> getFolderSources() {
        if (this.folderSources == null) {
            this.folderSources = new ArrayList<String>();
        }
        return this.folderSources;
    }
}

