/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.model;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.social.common.xmlprocessor.model.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private Node parentNode = null;
    private String title = "";
    private Attributes attributes = new Attributes();
    private String content = "";
    private LinkedList<Node> childNodes = new LinkedList();
    public static final List<String> selfCloseElements = Arrays.asList("area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "link", "meta", "param");

    public Node getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String nodeTitle) {
        this.title = nodeTitle;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public LinkedList<Node> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(LinkedList<Node> childNodes) {
        this.childNodes = childNodes;
    }

    public void addChildNode(Node childNode) {
        this.childNodes.add(childNode);
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public boolean isTextNode() {
        return this.attributes.size() == 0 && this.childNodes.size() == 0 && !this.content.isEmpty() && this.title.isEmpty();
    }

    public boolean isRootNode() {
        return this.parentNode == null && this.attributes.size() == 0 && this.content.isEmpty() && this.title.isEmpty();
    }

    public boolean isEmptyNode() {
        return this.childNodes.size() == 0 && this.content.isEmpty();
    }

    public boolean isSelfCloseAble() {
        return selfCloseElements.contains(this.title);
    }

    public void insertAfter(Node refNode, Node nodeToInsert) {
        if (refNode != null && nodeToInsert != null) {
            this.insertAfter(this.childNodes.indexOf(refNode), nodeToInsert);
        }
    }

    public void insertAfter(int position, Node node) {
        if (position + 1 <= this.childNodes.size() && node != null) {
            this.childNodes.add(position + 1, node);
        }
    }

    public String toString() {
        StringBuilder xmlString = new StringBuilder("");
        if (this.isTextNode()) {
            xmlString.append(this.content);
        } else {
            if (this.parentNode != null) {
                xmlString.append("<" + this.title);
                xmlString.append(this.attributes.toString());
                if (this.isSelfCloseAble() && this.isEmptyNode()) {
                    xmlString.append(" />");
                } else {
                    xmlString.append(">");
                }
            }
            for (Node childNode : this.childNodes) {
                xmlString.append(childNode.toString());
            }
            if (this.parentNode != null && !this.isSelfCloseAble()) {
                xmlString.append("</" + this.title + ">");
            }
        }
        return xmlString.toString();
    }

    private String toOpenString() {
        StringBuilder xmlString = new StringBuilder("");
        if (this.isTextNode()) {
            xmlString.append(this.content);
        } else if (this.parentNode != null) {
            xmlString.append("<" + this.title);
            xmlString.append(this.attributes.toString());
            if (this.isEmptyNode() && this.isSelfCloseAble()) {
                xmlString.append(" /");
            }
            xmlString.append(">");
        }
        return xmlString.toString();
    }

    private String toCloseString() {
        StringBuilder xmlString = new StringBuilder("");
        if (this.isTextNode()) {
            xmlString.append(this.content);
        } else if (this.parentNode != null && !this.isSelfCloseAble()) {
            xmlString.append("</" + this.title + ">");
        }
        return xmlString.toString();
    }

    public void convertToContent() {
        if (this.parentNode != null) {
            int thisPostion = this.parentNode.getChildNodes().indexOf(this);
            String content = this.toOpenString();
            String closeTag = this.toCloseString();
            this.title = "";
            this.attributes.clear();
            this.content = content;
            if (!closeTag.isEmpty()) {
                Node closeContentNode = new Node();
                closeContentNode.setContent(closeTag);
                this.childNodes.addLast(closeContentNode);
                this.moveAllChildNodesToOtherNode(this.parentNode, thisPostion);
            }
        }
    }

    private void moveAllChildNodesToOtherNode(Node destNode, int insertPosition) {
        if (destNode != null) {
            LinkedList<Node> parentChildNodes = destNode.getChildNodes();
            int postShift = insertPosition;
            for (Node childNode : this.childNodes) {
                childNode.setParentNode(destNode);
                parentChildNodes.add(++postShift, childNode);
            }
            this.childNodes.clear();
        }
    }
}

