/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy.codeassistant.extractors;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.exoplatform.ide.groovy.codeassistant.bean.MethodInfo;
import org.exoplatform.ide.groovy.codeassistant.bean.RoutineInfo;

public class RoutineInfoExtractor {
    public static RoutineInfo extractConstructorInfo(Constructor<?> constructor) {
        Type[] types = constructor.getGenericExceptionTypes();
        String[] genExceptionTypes = new String[types.length];
        for (int j = 0; j < types.length; ++j) {
            genExceptionTypes[j] = RoutineInfoExtractor.genericType2String(types[j]);
        }
        types = constructor.getGenericParameterTypes();
        String[] genericParameterTypes = new String[types.length];
        for (int j = 0; j < types.length; ++j) {
            genericParameterTypes[j] = RoutineInfoExtractor.genericType2String(types[j]);
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        String[] params = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            params[i] = parameterTypes[i].getSimpleName();
        }
        return new RoutineInfo(constructor.getModifiers(), constructor.getName(), genExceptionTypes, RoutineInfoExtractor.array2string(genericParameterTypes), RoutineInfoExtractor.array2string(params), constructor.toGenericString(), constructor.getDeclaringClass().getCanonicalName());
    }

    public static MethodInfo extractMethodInfo(Method method) {
        Type[] types = method.getGenericExceptionTypes();
        String[] genericExceptionTypes = new String[types.length];
        for (int j = 0; j < types.length; ++j) {
            genericExceptionTypes[j] = RoutineInfoExtractor.genericType2String(types[j]);
        }
        types = method.getParameterTypes();
        String[] genericParameterTypes = new String[types.length];
        for (int j = 0; j < types.length; ++j) {
            genericParameterTypes[j] = RoutineInfoExtractor.genericType2String(types[j]);
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        String[] params = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            params[i] = parameterTypes[i].getSimpleName();
        }
        return new MethodInfo(method.getModifiers(), method.getName(), genericExceptionTypes, RoutineInfoExtractor.array2string(genericParameterTypes), RoutineInfoExtractor.array2string(params), method.toGenericString(), method.getDeclaringClass().getCanonicalName(), RoutineInfoExtractor.genericType2String(method.getGenericReturnType()), method.getReturnType().getSimpleName());
    }

    private static String genericType2String(Type type) {
        return type instanceof Class ? RoutineInfoExtractor.getTypeName((Class)type) : type.toString();
    }

    private static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return type.getName();
    }

    private static String array2string(String[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "()";
        }
        StringBuilder b = new StringBuilder();
        b.append('(');
        int i = 0;
        while (true) {
            b.append(String.valueOf(a[i]));
            if (i == iMax) {
                return b.append(')').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

