/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import java.io.IOException;
import java.util.Iterator;
import org.jdesktop.jdic.desktop.Message;
import org.jdesktop.jdic.desktop.internal.LaunchFailedException;
import org.jdesktop.jdic.desktop.internal.MailerService;
import org.jdesktop.jdic.desktop.internal.impl.URLUTF8Encoder;

public class WinMozMailer
implements MailerService {
    private String mozLocation;

    public WinMozMailer() {
        this.mozLocation = "C:\\Program Files\\mozilla.org\\Mozilla\\mozilla.exe";
    }

    public WinMozMailer(String string) {
        this.mozLocation = string;
    }

    public void open(Message message) throws LaunchFailedException {
        String[] stringArray = new String[]{this.mozLocation, "-compose", this.constructArgs(message.getToAddrs(), message.getCcAddrs(), message.getBccAddrs(), message.getSubject(), message.getBody(), message.getAttachments())};
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            throw new LaunchFailedException("Cannot launch Mozilla composer via -compose commandline:" + iOException.getMessage());
        }
    }

    public void open() throws LaunchFailedException {
        String[] stringArray = new String[]{this.mozLocation, "-compose"};
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            throw new LaunchFailedException("Cannot launch Mozilla composer via -compose commandline:" + iOException.getMessage());
        }
    }

    private String constructArgs(Iterator iterator, Iterator iterator2, Iterator iterator3, String string, String string2, Iterator iterator4) {
        String string3 = "";
        String string4 = "";
        if (iterator != null) {
            while (iterator.hasNext()) {
                string4 = string4 + (String)iterator.next() + ",";
            }
            string3 = "to='" + string4 + "',";
        }
        if (iterator2 != null) {
            string4 = "";
            while (iterator2.hasNext()) {
                string4 = string4 + (String)iterator2.next() + ",";
            }
            string3 = string3 + "cc='" + string4 + "',";
        }
        if (iterator3 != null) {
            string4 = "";
            while (iterator3.hasNext()) {
                string4 = string4 + (String)iterator3.next() + ",";
            }
            string3 = string3 + "bcc='" + string4 + "',";
        }
        if (string != null) {
            string3 = string3 + "subject=" + this.parseSubject(URLUTF8Encoder.encode(string)) + ",";
        }
        if (string2 != null) {
            string3 = string3 + "body=<body>" + this.parseBody(URLUTF8Encoder.encode(string2)) + "</body>,";
        }
        if (iterator4 != null) {
            string4 = "";
            while (iterator4.hasNext()) {
                string4 = string4 + "file://" + (String)iterator4.next() + ",";
            }
            string3 = string3 + "attachment='" + string4 + "'";
        }
        return string3;
    }

    private String parseSubject(String string) {
        String string2 = string;
        string2 = string2.replaceAll("%0a", "%20");
        return string2;
    }

    private String parseBody(String string) {
        String string2 = string;
        string2 = string2.replaceAll("%3c", "&#60");
        string2 = string2.replaceAll("%3e", "&#62");
        string2 = string2.replaceAll("%0a", "<br>");
        return string2;
    }
}

