/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.webui;

import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputContainer;
import org.exoplatform.webui.form.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})
public class UIFormMultiValueInputSet
extends UIFormInputContainer<List> {
    protected Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    protected List<Validator> validators_;
    private Class<? extends UIFormInput> clazz_;
    private Constructor constructor_ = null;
    private List<Integer> listIndexItemRemoved = new ArrayList<Integer>();
    private int maxOld = 0;
    protected boolean enable_ = true;
    protected boolean readonly_ = false;

    public UIFormMultiValueInputSet() throws Exception {
        super(null, null);
    }

    public UIFormMultiValueInputSet(String name, String bindingField) throws Exception {
        super(name, bindingField);
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
    }

    public Class<List> getTypeValue() {
        return List.class;
    }

    public <E extends Validator> UIFormInput addValidator(Class<E> clazz, Object ... params) throws Exception {
        if (this.validators_ == null) {
            this.validators_ = new ArrayList<Validator>(3);
        }
        if (params.length > 0) {
            Class[] classes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                classes[i] = params[i].getClass();
            }
            Constructor<E> constructor = clazz.getConstructor(classes);
            this.validators_.add((Validator)constructor.newInstance(params));
            return this;
        }
        this.validators_.add((Validator)clazz.newInstance());
        return this;
    }

    public void setType(Class<? extends UIFormInput> clazz) {
        this.clazz_ = clazz;
        Constructor<?>[] constructors = this.clazz_.getConstructors();
        if (constructors.length > 0) {
            this.constructor_ = constructors[0];
            if (this.constructor_.getParameterTypes().length == 0) {
                this.constructor_ = constructors[constructors.length - 1];
            }
        }
    }

    public Class<? extends UIFormInput> getUIFormInputBase() {
        return this.clazz_;
    }

    public List<?> getValue() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (UIComponent child : this.getChildren()) {
            UIFormInputBase uiInput = (UIFormInputBase)child;
            if (uiInput.getValue() == null) continue;
            values.add(uiInput.getValue());
        }
        return values;
    }

    public UIFormInput setValue(List<?> values) throws Exception {
        this.getChildren().clear();
        for (int i = 0; i < values.size(); ++i) {
            UIFormInputBase uiInput = this.createUIFormInput(i);
            uiInput.setValue(values.get(i));
        }
        return this;
    }

    public boolean isEnable() {
        return this.enable_;
    }

    public UIFormMultiValueInputSet setEnable(boolean enable) {
        this.enable_ = enable;
        return this;
    }

    public boolean isEditable() {
        return !this.readonly_;
    }

    public UIFormMultiValueInputSet setEditable(boolean editable) {
        this.readonly_ = !editable;
        return this;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String action = uiForm.getSubmitAction();
        Event event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event == null) {
            return;
        }
        event.broadcast();
    }

    private String getResourceBundle(WebuiRequestContext context, String key, String dfValue) throws Exception {
        ResourceBundle res = context.getApplicationResourceBundle();
        UIPortletApplication app = (UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class);
        try {
            dfValue = res.getString(app.getId() + key);
        }
        catch (Exception e) {
            this.log.warn((Object)("Can not find resource bundle for key : " + app.getId() + key));
        }
        return dfValue;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.getChildren() == null || this.getChildren().size() < 1) {
            this.createUIFormInput(0);
        }
        Writer writer = context.getWriter();
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        int size = this.getChildren().size();
        String rmItem = this.getResourceBundle(context, ".label.RemoveItem", "Remove Item");
        String addItem = this.getResourceBundle(context, ".label.AddItem", "Add Item");
        String lbItem = uiForm.getLabel(this.getId());
        writer.append("<div class=\"UIFormMultiValueInputSet\" id=\"").append(this.getId()).append("\">");
        for (int i = 0; i < size; ++i) {
            UIFormInputBase uiInput = (UIFormInputBase)this.getChild(i);
            writer.append("<div class=\"MultiValueContainer\">");
            uiInput.setReadOnly(this.readonly_);
            uiInput.setDisabled(!this.enable_);
            uiInput.setHTMLAttribute("title", lbItem + " " + (i + 1));
            this.renderChild(uiInput.getId());
            if (size >= 2 || size == 1 && uiInput.getValue() != null) {
                writer.append("<img onclick=\"");
                writer.append(uiForm.event("Remove", uiInput.getId())).append("\" title=\"").append(rmItem).append("\" alt=\"").append(rmItem).append("\"");
                writer.append(" class=\"MultiFieldAction Remove16x16Icon\" src=\"/eXoResources/skin/sharedImages/Blank.gif\" />");
            }
            if (i == size - 1) {
                writer.append("<img onclick=\"");
                writer.append(uiForm.event("Add", this.getId())).append("\" title=\"").append(addItem).append("\" alt=\"").append(addItem).append("\"");
                writer.append(" class=\"MultiFieldAction AddNewNodeIcon\" src=\"/eXoResources/skin/sharedImages/Blank.gif\" />");
            }
            writer.append("</div>");
        }
        writer.append("</div>");
    }

    public UIFormInputBase createUIFormInput(int idx) throws Exception {
        Class<?>[] classes = this.constructor_.getParameterTypes();
        Object[] params = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].isPrimitive()) continue;
            params[i] = classes[i] == Boolean.TYPE ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
        }
        params[0] = this.getId() + String.valueOf(idx);
        UIFormInputBase inputBase = (UIFormInputBase)this.constructor_.newInstance(params);
        if (this.validators_ != null) {
            for (Validator validator : this.validators_) {
                inputBase.addValidator(validator.getClass(), new Object[0]);
            }
        }
        this.addChild((UIComponent)inputBase);
        return inputBase;
    }

    public void resetListIndexItemRemoved() {
        this.listIndexItemRemoved = new ArrayList<Integer>();
    }

    public List<Integer> getListIndexItemRemoved() {
        return this.listIndexItemRemoved;
    }

    public void setMaxOld(int maxOld) {
        this.maxOld = maxOld;
    }

    public int getMaxOld() {
        return this.maxOld;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            uiSet.removeChildById(id);
            uiSet.listIndexItemRemoved.add(Integer.parseInt(id.replaceAll(uiSet.getId(), "")));
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSet.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            List children;
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            if (uiSet.getId().equals(id) && (children = uiSet.getChildren()).size() > 0) {
                UIFormInputBase uiInput = (UIFormInputBase)children.get(children.size() - 1);
                String index = uiInput.getId();
                int maxIndex = Integer.parseInt(index.replaceAll(id, ""));
                if (maxIndex < uiSet.maxOld) {
                    maxIndex = uiSet.maxOld;
                    while (uiSet.getChildById(id + String.valueOf(maxIndex)) != null) {
                        ++maxIndex;
                    }
                }
                uiSet.createUIFormInput(maxIndex + 1);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSet.getParent());
        }
    }
}

