/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.authentication;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.login.LoginException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;

public class BasicAuthFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger((String)BasicAuthFilter.class.getName());

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String auth = httpRequest.getHeader("Authorization");
        if (auth == null) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setStatus(401);
            httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"exo-domain\"");
            return;
        }
        byte[] token = Base64.decodeBase64((byte[])auth.substring(6).getBytes());
        String username = null;
        String password = null;
        int colon = -1;
        for (int i = 0; i < token.length; ++i) {
            if (token[i] != 58) continue;
            colon = i;
        }
        if (colon < 0) {
            username = new String(token);
        } else {
            username = new String(token, 0, colon);
            password = new String(token, colon + 1, token.length - colon - 1);
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container == null) {
            container = ExoContainerContext.getTopContainer();
        }
        try {
            Authenticator authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
            if (authenticator == null) {
                LOG.error((Object)"Authenticator not found");
            }
            Credential[] credentials = new Credential[]{new UsernameCredential(username), new PasswordCredential(password)};
            String userId = authenticator.validateUser(credentials);
            Identity identity = authenticator.createIdentity(userId);
            IdentityRegistry ir = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
            if (ir == null) {
                LOG.error((Object)"Authenticator not found");
            }
            ir.register(identity);
            ConversationState.setCurrent((ConversationState)new ConversationState(identity));
            chain.doFilter((ServletRequest)new AuthServletRequest(httpRequest, identity), response);
        }
        catch (LoginException e) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setStatus(401);
            httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"exo-domain\"");
            return;
        }
        catch (Exception e) {
            LOG.error((Object)"Error occurs ", (Throwable)e);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setStatus(403);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private class MockPrincipal
    implements Principal {
        private String username;

        public MockPrincipal(String username) {
            this.username = username;
        }

        @Override
        public String getName() {
            return this.username;
        }
    }

    final class AuthServletRequest
    extends HttpServletRequestWrapper {
        private final Identity identity;

        public AuthServletRequest(HttpServletRequest request, Identity identity) {
            super(request);
            this.identity = identity;
        }

        public String getRemoteUser() {
            return this.identity.getUserId();
        }

        public Principal getUserPrincipal() {
            return new MockPrincipal(this.identity.getUserId());
        }

        public boolean isUserInRole(String role) {
            return this.identity.getRoles().contains(role);
        }
    }
}

