/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.rest.xml;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.authentication.rest.RESTAuthenticator;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.rest.RESTOrganizationServiceAbstractImpl;
import org.exoplatform.services.organization.rest.xml.CountXMLEntity;
import org.exoplatform.services.organization.rest.xml.GroupListXMLEntity;
import org.exoplatform.services.organization.rest.xml.GroupXMLEntity;
import org.exoplatform.services.organization.rest.xml.UserListXMLEntity;
import org.exoplatform.services.organization.rest.xml.UserXMLEntity;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/organization/xml/")
public class RESTOrganizationServiceXMLImpl
extends RESTOrganizationServiceAbstractImpl
implements ResourceContainer {
    protected static final String XML_CONTENT_TYPE = "text/xml";

    public RESTOrganizationServiceXMLImpl(OrganizationService organizationService) {
        super(organizationService);
    }

    @GET
    @Path(value="/user/find-all/")
    public Response findUsers(@Context UriInfo uriInfo, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate) {
        username = RESTAuthenticator.decodeUsername(username);
        try {
            Query query = this.createFindUsersQuerry(username, firstname, lastname, email, fromLoginDate, toLoginDate);
            ArrayList<User> list = new ArrayList<User>();
            PageList pageList = this.userHandler.findUsers(query);
            int pages = pageList.getAvailablePage();
            for (int i = 1; i <= pages; ++i) {
                list.addAll(pageList.getPage(i));
            }
            return Response.ok((Object)new UserListXMLEntity(list, uriInfo.getBaseUri().getPath()), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Thrown exception : ", (Throwable)e);
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    @GET
    @Path(value="/user/find-all/{from}/{num}/")
    public Response findUsersRange(@Context UriInfo uriInfo, @QueryParam(value="username") String username, @QueryParam(value="firstname") String firstname, @QueryParam(value="lastname") String lastname, @QueryParam(value="email") String email, @QueryParam(value="fromLoginDate") String fromLoginDate, @QueryParam(value="toLogindate") String toLoginDate, @PathParam(value="from") Integer from, @PathParam(value="num") Integer numResult) {
        username = RESTAuthenticator.decodeUsername(username);
        try {
            Query query = this.createFindUsersQuerry(username, firstname, lastname, email, fromLoginDate, toLoginDate);
            ArrayList<User> list = new ArrayList();
            PageList pageList = this.userHandler.findUsers(query);
            pageList.setPageSize(numResult.intValue());
            int page = from / numResult + 1;
            list = pageList.getPage(page);
            return Response.ok((Object)new UserListXMLEntity(list, uriInfo.getBaseUri().getPath()), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Thrown exception : ", (Throwable)e);
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    private Query createFindUsersQuerry(String username, String firstname, String lastname, String email, String fromLoginDate, String toLoginDate) {
        Query query = new Query();
        query.setUserName(username);
        query.setFirstName(firstname);
        query.setLastName(lastname);
        query.setEmail(email);
        if (fromLoginDate != null) {
            try {
                query.setFromLoginDate(DateFormat.getDateTimeInstance().parse(fromLoginDate));
            }
            catch (ParseException e) {
                LOGGER.warn((Object)("Thrown exception : " + e));
            }
        }
        if (toLoginDate != null) {
            try {
                query.setToLoginDate(DateFormat.getDateTimeInstance().parse(toLoginDate));
            }
            catch (ParseException e) {
                LOGGER.warn((Object)("Thrown exception : " + e));
            }
        }
        return query;
    }

    @GET
    @Path(value="/user/view-range/{from}/{num}/")
    public Response getUsersRange(@Context UriInfo uriInfo, @PathParam(value="from") Integer from, @PathParam(value="num") Integer numResult) {
        try {
            List list = new ArrayList();
            PageList pageList = this.userHandler.getUserPageList(numResult.intValue());
            int page = from / numResult + 1;
            list = pageList.getPage(page);
            ArrayList<User> cloneList = new ArrayList<User>();
            for (User user : list) {
                if (user == null) continue;
                cloneList.add(user);
            }
            return Response.ok((Object)new UserListXMLEntity(cloneList, uriInfo.getBaseUri().getPath()), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Thrown exception : ", (Throwable)e);
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    @GET
    @Path(value="/user/count/")
    public Response getUsersCount() {
        try {
            int number = this.userHandler.getUserPageList(20).getAvailable();
            return Response.ok((Object)new CountXMLEntity(number, "users"), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Thrown exception : ", (Throwable)e);
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    @GET
    @Path(value="/user/info/{username}/")
    public Response getUser(@PathParam(value="username") String username) {
        username = RESTAuthenticator.decodeUsername(username);
        try {
            User user = this.userHandler.findUserByName(username);
            if (user == null) {
                return Response.status((int)404).entity((Object)("User '" + username + "' not found.")).build();
            }
            return Response.ok((Object)new UserXMLEntity(user), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Thrown exception : ", (Throwable)e);
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    @GET
    @Path(value="/group/info/{groupId}/")
    public Response getGroup(@Context UriInfo uriInfo, @PathParam(value="groupId") String groupId) {
        try {
            groupId = groupId.startsWith("/") ? groupId : "/" + groupId;
            Group group = this.groupHandler.findGroupById(groupId);
            if (group == null) {
                return Response.status((int)404).entity((Object)("Group '" + groupId + "' not found.")).build();
            }
            ArrayList<User> members = new ArrayList<User>();
            PageList pageList = this.userHandler.findUsersByGroup(groupId);
            int pages = pageList.getAvailablePage();
            for (int i = 1; i <= pages; ++i) {
                members.addAll(pageList.getPage(i));
            }
            return Response.ok((Object)new GroupXMLEntity(group, members, uriInfo.getBaseUri().getPath()), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Thrown exception : ", (Throwable)e);
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    @GET
    @Path(value="/group/view-all/")
    public Response getGroups(@Context UriInfo uriInfo, @QueryParam(value="parentId") String parentId) {
        try {
            Collection groups = null;
            if (parentId != null && parentId.length() > 0) {
                Group parent = this.groupHandler.findGroupById(parentId = parentId.startsWith("/") ? parentId : "/" + parentId);
                if (parent == null) {
                    return Response.status((int)404).entity((Object)("Parent '" + parentId + "' not found.")).build();
                }
                groups = this.groupHandler.findGroups(parent);
            } else {
                groups = this.groupHandler.findGroups(null);
            }
            return Response.ok((Object)new GroupListXMLEntity(groups, uriInfo.getBaseUri().getPath()), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Thrown exception : ", (Throwable)e);
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    @GET
    @Path(value="/group/count/")
    public Response getGroupsCount() {
        try {
            int number = this.groupHandler.getAllGroups().size();
            return Response.ok((Object)new CountXMLEntity(number, "groups"), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Thrown exception : ", (Throwable)e);
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    @GET
    @Path(value="/group/groups-for-user/")
    public Response getGroupsOfUser(@Context UriInfo uriInfo, @QueryParam(value="username") String username) {
        username = RESTAuthenticator.decodeUsername(username);
        try {
            if (this.userHandler.findUserByName(username) == null) {
                return Response.status((int)404).entity((Object)("User '" + username + "' not found.")).build();
            }
            Collection groups = this.groupHandler.findGroupsOfUser(username);
            return Response.ok((Object)new GroupListXMLEntity(groups, uriInfo.getBaseUri().getPath()), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Thrown exception : ", (Throwable)e);
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }

    @GET
    @Path(value="/group/view-from-to/{from}/{to}/")
    public Response getGroupsRange(@Context UriInfo uriInfo, @PathParam(value="from") Integer offset, @PathParam(value="to") Integer amount, @QueryParam(value="parentId") String parentId) {
        try {
            Collection groups = null;
            if (parentId != null && parentId.length() > 0) {
                Group parent = this.groupHandler.findGroupById(parentId = parentId.startsWith("/") ? parentId : "/" + parentId);
                if (parent == null) {
                    return Response.status((int)404).entity((Object)("Parent '" + parentId + "' not found.")).build();
                }
                groups = this.groupHandler.findGroups(parent);
            } else {
                groups = this.groupHandler.findGroups(null);
            }
            Integer amount_ = amount;
            if (amount > groups.size()) {
                amount_ = groups.size();
            }
            return Response.ok((Object)new GroupListXMLEntity(new ArrayList(groups).subList(offset, amount_), uriInfo.getBaseUri().getPath()), (String)XML_CONTENT_TYPE).build();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Thrown exception : ", (Throwable)e);
            return Response.status((int)500).entity((Object)("Thrown exception : " + e)).build();
        }
    }
}

