/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.jcr.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Account {
    private String id = "";
    private String label = "";
    private String userDisplayName = "";
    private String emailAddress = "";
    private String emailReplyAddress = "";
    private String signature = "";
    private String description = "";
    private boolean checkedAuto_ = false;
    private boolean emptyTrashWhenExit = false;
    private boolean isSavePassword_ = false;
    private String placeSignature = "";
    private Date lastCheckedDate_;
    private Date lastStartCheckingTime_;
    private boolean checkAll_ = false;
    private Date checkFromDate_;
    private Map<String, String> serverProperties = new HashMap<String, String>();
    private Map<String, String> smtpServerProperties = new HashMap<String, String>();
    private String secureAuthsIncoming = Utils.getIncomingSecureAuthentication();
    private String secureAuthsOutgoing = Utils.getOutgoingSecureAuthentication();
    private String authMechsIncoming = "plain";
    private String authMechsOutgoing = "plain";
    private Map<String, String> permissions = new HashMap<String, String>();
    private String delegateFrom_ = "";

    public String getSecureAuthsIncoming() {
        if (this.secureAuthsIncoming == "ssl/tls") {
            return "SSL";
        }
        return this.secureAuthsIncoming;
    }

    public void setSecureAuthsIncoming(String secureAuthsIncoming) {
        this.secureAuthsIncoming = secureAuthsIncoming;
    }

    public String getSecureAuthsOutgoing() {
        if (this.secureAuthsOutgoing == "ssl/tls") {
            return "SSL";
        }
        return this.secureAuthsOutgoing;
    }

    public void setSecureAuthsOutgoing(String secureAuthsOutgoing) {
        this.secureAuthsOutgoing = secureAuthsOutgoing;
    }

    public String getAuthMechsIncoming() {
        if (this.authMechsIncoming.equalsIgnoreCase("kerberos/gssapi")) {
            return "GSSAPI";
        }
        return this.authMechsIncoming;
    }

    public void setAuthMechsIncoming(String authMechsIncoming) {
        this.authMechsIncoming = authMechsIncoming;
    }

    public String getAuthMechsOutgoing() {
        if (this.authMechsIncoming.equalsIgnoreCase("kerberos/gssapi")) {
            return "GSSAPI";
        }
        return this.authMechsOutgoing;
    }

    public void setAuthMechsOutgoing(String authMechsOutgoing) {
        this.authMechsOutgoing = authMechsOutgoing;
    }

    public Account() {
        this.id = Utils.KEY_ACCOUNT + IdGenerator.generate();
        this.setServerProperty(Utils.SVR_LEAVE_ON_SERVER, Utils.getLeaveOnServer());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String s) {
        this.id = s;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String s) {
        this.signature = s;
    }

    public String getEmailReplyAddress() {
        return this.emailReplyAddress;
    }

    public void setEmailReplyAddress(String s) {
        this.emailReplyAddress = s;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String s) {
        this.emailAddress = s;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public void setUserDisplayName(String s) {
        this.userDisplayName = s;
    }

    public boolean checkedAuto() {
        return this.checkedAuto_;
    }

    public void setCheckedAuto(boolean checkedAuto) {
        this.checkedAuto_ = checkedAuto;
    }

    public boolean isSavePassword() {
        return this.isSavePassword_;
    }

    public void setIsSavePassword(boolean isSavePassword) {
        this.isSavePassword_ = isSavePassword;
    }

    public boolean isEmptyTrashWhenExit() {
        return this.emptyTrashWhenExit;
    }

    public void setEmptyTrashWhenExit(boolean bool) {
        this.emptyTrashWhenExit = bool;
    }

    public String getPlaceSignature() {
        return this.placeSignature;
    }

    public void setPlaceSignature(String placeSig) {
        this.placeSignature = placeSig;
    }

    public Date getLastCheckedDate() {
        return this.lastCheckedDate_;
    }

    public void setLastCheckedDate(Date date) {
        this.lastCheckedDate_ = date;
    }

    public Date getLastStartCheckingTime() {
        return this.lastStartCheckingTime_;
    }

    public void setLastStartCheckingTime(Date date) {
        this.lastStartCheckingTime_ = date;
    }

    public boolean isCheckAll() {
        return this.checkAll_;
    }

    public void setCheckAll(boolean b) {
        this.checkAll_ = b;
    }

    public Date getCheckFromDate() {
        return this.checkFromDate_;
    }

    public void setCheckFromDate(Date date) {
        this.checkFromDate_ = date;
    }

    public Folder getFolderByName(String name) {
        return null;
    }

    public boolean isOutgoingAuthentication() {
        return Boolean.valueOf(this.smtpServerProperties.get(Utils.SMTP_ISAUTHENTICATION));
    }

    public void setIsOutgoingAuthentication(boolean b) {
        this.setSmtpServerProperty(Utils.SMTP_ISAUTHENTICATION, String.valueOf(b));
    }

    public boolean useIncomingSettingForOutgoingAuthent() {
        return Boolean.valueOf(this.smtpServerProperties.get(Utils.SMTP_USEINCOMINGSETTING));
    }

    public void setUseIncomingForAuthentication(boolean b) {
        this.setSmtpServerProperty(Utils.SMTP_USEINCOMINGSETTING, String.valueOf(b));
    }

    public String getOutgoingUserName() {
        return this.smtpServerProperties.get(Utils.SVR_OUTGOING_USERNAME);
    }

    public void setOutgoingUserName(String username) {
        this.setSmtpServerProperty(Utils.SVR_OUTGOING_USERNAME, username);
    }

    public String getOutgoingPassword() {
        return this.smtpServerProperties.get(Utils.SVR_OUTGOING_PASSWORD);
    }

    public void setOutgoingPassword(String password) {
        this.setSmtpServerProperty(Utils.SVR_OUTGOING_PASSWORD, password);
    }

    public void setServerProperty(String key, String value) {
        if (this.serverProperties == null) {
            this.serverProperties = new HashMap<String, String>();
        }
        this.serverProperties.put(key, value);
    }

    public Map<String, String> getServerProperties() {
        return this.serverProperties;
    }

    public String getProtocol() {
        return this.serverProperties.get(Utils.SVR_PROTOCOL);
    }

    public void setProtocol(String protocol) {
        this.setServerProperty(Utils.SVR_PROTOCOL, protocol);
    }

    public String getIncomingHost() {
        return this.serverProperties.get(Utils.SVR_INCOMING_HOST);
    }

    public void setIncomingHost(String host) {
        this.setServerProperty(Utils.SVR_INCOMING_HOST, host);
    }

    public String getIncomingPort() {
        return this.serverProperties.get(Utils.SVR_INCOMING_PORT);
    }

    public void setIncomingPort(String port) {
        this.setServerProperty(Utils.SVR_INCOMING_PORT, port);
    }

    public String getOutgoingHost() {
        return this.serverProperties.get(Utils.SVR_OUTGOING_HOST);
    }

    public void setOutgoingHost(String host) {
        this.setServerProperty(Utils.SVR_OUTGOING_HOST, host);
    }

    public String getOutgoingPort() {
        return this.serverProperties.get(Utils.SVR_OUTGOING_PORT);
    }

    public void setOutgoingPort(String port) {
        this.setServerProperty(Utils.SVR_OUTGOING_PORT, port);
    }

    public boolean isCustomInbox() {
        return Boolean.valueOf(this.serverProperties.get(Utils.SVR_IS_CUSTOM_INBOX));
    }

    public void setIsCustomInbox(boolean b) {
        this.setServerProperty(Utils.SVR_IS_CUSTOM_INBOX, String.valueOf(b));
    }

    public String getIncomingFolder() {
        return this.serverProperties.get(Utils.SVR_INCOMING_FOLDER);
    }

    public void setIncomingFolder(String folder) {
        this.setServerProperty(Utils.SVR_INCOMING_FOLDER, folder);
    }

    public String getIncomingUser() {
        return this.serverProperties.get(Utils.SVR_INCOMING_USERNAME);
    }

    public void setIncomingUser(String user) {
        this.setServerProperty(Utils.SVR_INCOMING_USERNAME, user);
    }

    public String getIncomingPassword() {
        return this.serverProperties.get(Utils.SVR_INCOMING_PASSWORD);
    }

    public void setIncomingPassword(String password) {
        this.setServerProperty(Utils.SVR_INCOMING_PASSWORD, password);
    }

    public boolean isIncomingSsl() {
        return this.serverProperties.get(Utils.SVR_INCOMING_SSL).equalsIgnoreCase("true");
    }

    public void setIncomingSsl(boolean b) {
        this.setServerProperty(Utils.SVR_INCOMING_SSL, String.valueOf(b));
    }

    public boolean isOutgoingSsl() {
        return this.serverProperties.get(Utils.SVR_OUTGOING_SSL).equalsIgnoreCase("true");
    }

    public void setOutgoingSsl(boolean b) {
        this.setServerProperty(Utils.SVR_OUTGOING_SSL, String.valueOf(b));
    }

    public void setSmtpServerProperty(String key, String value) {
        if (this.smtpServerProperties == null) {
            this.smtpServerProperties = new HashMap<String, String>();
        }
        this.smtpServerProperties.put(key, value);
    }

    public Map<String, String> getSmtpServerProperties() {
        return this.smtpServerProperties;
    }

    public void setPermissions(Map<String, String> permissions) {
        this.permissions = permissions;
    }

    public Map<String, String> getPermissions() {
        return this.permissions;
    }

    public void setDelegateFrom(String delegateFrom) {
        this.delegateFrom_ = delegateFrom;
    }

    public String getDelegateFrom() {
        return this.delegateFrom_;
    }
}

