/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc.drivers.modifiers;

import com.arjuna.ats.internal.jdbc.drivers.modifiers.list;
import java.util.Enumeration;
import java.util.Hashtable;

public class ModifierFactory {
    private static Hashtable _modifiers = new Hashtable();

    public static synchronized void putModifier(String dbName, int major, int minor, String modclass) {
        try {
            Object mod = Thread.currentThread().getContextClassLoader().loadClass(modclass).newInstance();
            _modifiers.put(dbName + "_" + major + "_" + minor, mod);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static synchronized Object getModifier(String dbName, int major, int minor) {
        String exactMatch = null;
        String majorMatch = null;
        String driverMatch = null;
        Enumeration e = _modifiers.keys();
        dbName = dbName.toLowerCase();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (s.equalsIgnoreCase(dbName + "_" + major + "_" + minor)) {
                exactMatch = s;
            }
            if (s.equalsIgnoreCase(dbName + "_" + major + "_-1")) {
                majorMatch = s;
            }
            if (!s.equalsIgnoreCase(dbName + "_-1_-1")) continue;
            driverMatch = s;
        }
        if (exactMatch != null) {
            return _modifiers.get(exactMatch);
        }
        if (majorMatch != null) {
            return _modifiers.get(majorMatch);
        }
        if (driverMatch != null) {
            return _modifiers.get(driverMatch);
        }
        return null;
    }

    static {
        list list2 = new list();
    }
}

