/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeVotingNodeTypePlugin
extends UpgradeProductPlugin {
    private static final String VOTER_VOTEVALUE_PROP = "exo:voterVoteValues";
    private static final String MIX_VOTABLE = "mix:votable";
    private DMSConfiguration dmsConfiguration_;
    private RepositoryService repoService_;
    private static final Log LOG = ExoLogger.getLogger((String)UpgradeVotingNodeTypePlugin.class.getName());

    public UpgradeVotingNodeTypePlugin(RepositoryService repoService, DMSConfiguration dmsConfiguration, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
        this.dmsConfiguration_ = dmsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Session session = sessionProvider.getSession(this.dmsConfiguration_.getConfig().getSystemWorkspace(), this.repoService_.getCurrentRepository());
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
            NodeTypeValue mixVotableNodeTypeValue = nodeTypeManager.getNodeTypeValue(MIX_VOTABLE);
            List propertyDefinitionList = mixVotableNodeTypeValue.getDeclaredPropertyDefinitionValues();
            boolean propertyExists = false;
            for (PropertyDefinitionValue propertyDefinition : propertyDefinitionList) {
                if (!propertyDefinition.getName().equals(VOTER_VOTEVALUE_PROP)) continue;
                propertyExists = true;
                break;
            }
            if (!propertyExists) {
                propertyDefinitionList.add(new PropertyDefinitionValue(VOTER_VOTEVALUE_PROP, false, false, 1, false, new ArrayList(), true, 1, new ArrayList()));
                mixVotableNodeTypeValue.setDeclaredPropertyDefinitionValues(propertyDefinitionList);
                nodeTypeManager.registerNodeType(mixVotableNodeTypeValue, 4);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Add new property 'exo:voterVoteValues' for node type 'mix:votable' successfully!");
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An unexpected error occurs when add new property 'exo:voterVoteValues' for node type 'mix:votable'!", (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

