/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.protocols.UNICAST;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.Util;

public class UnicastEnableToTest
extends TestCase {
    JChannel channel = null;
    JChannel channel2 = null;
    AgeOutCache cache;

    public UnicastEnableToTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.channel = new JChannel("udp.xml");
        this.channel.connect("demo-group");
        UNICAST ucast = (UNICAST)this.channel.getProtocolStack().findProtocol(UNICAST.class);
        AgeOutCache ageOutCache = this.cache = ucast != null ? ucast.getAgeOutCache() : null;
        if (this.cache != null) {
            this.cache.setTimeout(1000L);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Util.close(this.channel2, this.channel);
    }

    public void testUnicastMessageToUnknownMember() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 8976);
        System.out.println("sending message to non-existing destination " + addr);
        this.channel.send(new Message((Address)addr, null, (Serializable)((Object)"Hello world")));
        if (this.cache != null) {
            System.out.println("age out cache:\n" + this.cache);
            assert (this.cache.size() == 1);
        }
        Util.sleep(1500L);
        if (this.cache != null) assert (this.cache.size() == 0);
    }

    public void testUnicastMessageToExistingMember() throws Exception {
        this.channel2 = new JChannel("udp.xml");
        this.channel2.connect("demo-group");
        UnicastEnableToTest.assertEquals((int)2, (int)this.channel2.getView().size());
        MyReceiver receiver = new MyReceiver();
        this.channel2.setReceiver(receiver);
        Address dest = this.channel2.getLocalAddress();
        this.channel.send(new Message(dest, null, (Serializable)((Object)"hello")));
        Util.sleep(500L);
        List list = receiver.getMsgs();
        System.out.println("channel2 received the following msgs: " + list);
        UnicastEnableToTest.assertEquals((int)1, (int)list.size());
        receiver.reset();
    }

    public void testUnicastMessageToLeftMember() throws Exception {
        this.channel2 = new JChannel("udp.xml");
        this.channel2.connect("demo-group");
        UnicastEnableToTest.assertEquals((int)2, (int)this.channel2.getView().size());
        Address dest = this.channel2.getLocalAddress();
        this.channel2.close();
        Util.sleep(100L);
        this.channel.send(new Message(dest, null, (Serializable)((Object)"hello")));
        if (this.cache != null) {
            System.out.println("age out cache:\n" + this.cache);
            assert (this.cache.size() == 1);
        }
        Util.sleep(1500L);
        if (this.cache != null) assert (this.cache.size() == 0) : "cache size is " + this.cache.size();
    }

    public void testUnicastMessageToLeftMemberWithEnableUnicastToEvent() throws Exception {
        this.channel2 = new JChannel("udp.xml");
        this.channel2.connect("demo-group");
        UnicastEnableToTest.assertEquals((int)2, (int)this.channel2.getView().size());
        Address dest = this.channel2.getLocalAddress();
        this.channel2.close();
        Util.sleep(100L);
        this.channel.send(new Message(dest, null, (Serializable)((Object)"hello")));
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{UnicastEnableToTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private static class MyReceiver
    extends ExtendedReceiverAdapter {
        List<Message> msgs = new LinkedList<Message>();

        private MyReceiver() {
        }

        @Override
        public void receive(Message msg) {
            this.msgs.add(msg);
        }

        List getMsgs() {
            return this.msgs;
        }

        void reset() {
            this.msgs.clear();
        }
    }
}

