/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.portlet.PortletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.ecm.webui.presentation.removeattach.RemoveAttachmentComponent;
import org.exoplatform.ecm.webui.presentation.removecomment.RemoveCommentComponent;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={ChangeNodeActionListener.class})})
public class UIViewSearchResult
extends UIBaseNodePresentation {
    private NodeLocation node_;
    private String language_;
    private static final String COMMENT_COMPONENT = "Comment";
    private static final Log LOG = ExoLogger.getLogger((String)UIViewSearchResult.class.getName());

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            String nodeType = this.getOriginalNode().getPrimaryNodeType().getName();
            return templateService.getTemplatePathByUser(false, nodeType, userName);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return null;
        }
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        Node originalNode = this.getOriginalNode();
        NodeIterator childrenIterator = originalNode.getNodes();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        int attachData = 0;
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List listCanCreateNodeType = org.exoplatform.ecm.webui.utils.Utils.getListAllowedFileType((Node)originalNode, (TemplateService)templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            if (childNode.hasProperty("jcr:data")) {
                attachData = childNode.getProperty("jcr:data").getStream().available();
                if (attachData <= 0) continue;
                attachments.add(childNode);
                continue;
            }
            attachments.add(childNode);
        }
        return attachments;
    }

    @Deprecated
    public String getAttachmentURL(Node attNode, Parameter[] params) throws Exception {
        return this.getViewableLink(attNode, params);
    }

    public String getViewableLink(Node attNode, Parameter[] params) throws Exception {
        return this.event("ChangeNode", org.exoplatform.ecm.webui.utils.Utils.formatNodeName((String)attNode.getPath()), params);
    }

    public UIComponent getRemoveAttach() throws Exception {
        this.removeChild(RemoveAttachmentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveAttachmentComponent.class, null, "UIViewSearchResultRemoveAttach");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPopupWindow.class));
        return uicomponent;
    }

    public UIComponent getRemoveComment() throws Exception {
        this.removeChild(RemoveCommentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveCommentComponent.class, null, "UIViewSearchResultRemoveComment");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPopupWindow.class));
        return uicomponent;
    }

    public Node getNode() throws ValueFormatException, PathNotFoundException, RepositoryException {
        Node originalNode = this.getOriginalNode();
        if (originalNode.hasProperty("exo:language")) {
            String defaultLang = originalNode.getProperty("exo:language").getString();
            if (this.language_ == null) {
                this.language_ = defaultLang;
            }
            if (originalNode.hasNode("languages") && !this.language_.equals(defaultLang)) {
                Node curNode = originalNode.getNode("languages/" + this.language_);
                return curNode;
            }
            return originalNode;
        }
        return originalNode;
    }

    public Node getOriginalNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.node_);
    }

    public String getIcons(Node node, String size) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)node, (String)size);
    }

    public String getNodeType() throws Exception {
        return null;
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        Node originalNode = this.getOriginalNode();
        if (originalNode.hasProperty("exo:relation")) {
            Value[] vals = originalNode.getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                relations.add(node);
            }
        }
        return relations;
    }

    public boolean isRssLink() {
        return false;
    }

    public String getRssLink() {
        return null;
    }

    public List<String> getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.getOriginalNode());
    }

    public String getTemplatePath() throws Exception {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public boolean isNodeTypeSupported(String nodeTypeName) {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            return templateService.isManagedNodeType(nodeTypeName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public UIComponent getCommentComponent() {
        UIViewSearchResult uicomponent;
        block2: {
            uicomponent = null;
            try {
                UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
                HashMap<String, UIJCRExplorer> context = new HashMap<String, UIJCRExplorer>();
                UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
                context.put(UIJCRExplorer.class.getName(), uiExplorer);
                context.put(Node.class.getName(), (UIJCRExplorer)this.node_);
                uicomponent = manager.addUIExtension("org.exoplatform.ecm.dms.UIActionBar", COMMENT_COMPONENT, context, (UIContainer)this);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"An error occurs while checking the action", (Throwable)e);
            }
        }
        return uicomponent != null ? uicomponent : this;
    }

    public boolean hasPropertyContent(Node node, String property) {
        block3: {
            try {
                String value = node.getProperty(property).getString();
                if (value.length() > 0) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e);
            }
        }
        return false;
    }

    public void setNode(Node node) {
        this.node_ = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        String[] workspaces = manageRepo.getWorkspaceNames();
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        for (String ws : workspaces) {
            try {
                return sessionProvider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.getOriginalNode(), this.language_);
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName);
    }

    public String getLanguage() {
        return this.language_;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public Object getComponentInstanceOfType(String className) {
        Object service;
        block2: {
            service = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = loader.loadClass(className);
                service = this.getApplicationComponent(clazz);
            }
            catch (ClassNotFoundException ex) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)ex);
            }
        }
        return service;
    }

    public String getImage(Node node) throws Exception {
        DownloadService downloadService = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource inputResource = new InputStreamDownloadResource(input, "image");
        inputResource.setDownloadName(node.getName());
        return downloadService.getDownloadLink(downloadService.addDownloadResource((DownloadResource)inputResource));
    }

    public String getImage(Node node, String nodeTypeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode(nodeTypeName);
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getRepository() throws Exception {
        return ((ManageableRepository)this.getOriginalNode().getSession().getRepository()).getConfiguration().getName();
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext pRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        PortletRequest pRequest = pRequestContext.getRequest();
        String prefixWebDAV = pRequest.getScheme() + "://" + pRequest.getServerName() + ":" + String.format("%s", pRequest.getServerPort());
        return prefixWebDAV;
    }

    public String getWorkspaceName() throws Exception {
        return this.getOriginalNode().getSession().getWorkspace().getName();
    }

    public String getDownloadLink(Node node) throws Exception {
        return Utils.getDownloadLink((Node)node);
    }

    public String encodeHTML(String text) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.encodeHTML((String)text);
    }

    public String getTemplateSkin(String nodeTypeName, String skinName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getSkinPath(nodeTypeName, skinName, this.getLanguage());
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getUIComponent((String)mimeType, (UIContainer)this);
    }

    public boolean isEnableComment() {
        return false;
    }

    public boolean isEnableVote() {
        return false;
    }

    public void setEnableComment(boolean value) {
    }

    public void setEnableVote(boolean value) {
    }

    public String getInlineEditingField(Node orgNode, String propertyName, String defaultValue, String inputType, String idGenerator, String cssClass, boolean isGenericProperty, String ... arguments) throws Exception {
        if (orgNode.hasProperty(propertyName)) {
            return orgNode.getProperty(propertyName).getString();
        }
        return defaultValue;
    }

    public String getInlineEditingField(Node orgNode, String propertyName) throws Exception {
        if (orgNode.hasProperty(propertyName)) {
            return orgNode.getProperty(propertyName).getString();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIViewSearchResult> {
        public void execute(Event<UIViewSearchResult> event) throws Exception {
            UIViewSearchResult uicomp = (UIViewSearchResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            String uri = event.getRequestContext().getRequestParameter("objectId");
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            Session session = uiExplorer.getSessionByWorkspace(workspaceName);
            Node selectedNode = (Node)session.getItem(uri);
            uicomp.setNode(selectedNode);
            event.getRequestContext().addUIComponentToUpdateByAjax(uicomp.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DownloadActionListener
    extends EventListener<UIViewSearchResult> {
        public void execute(Event<UIViewSearchResult> event) throws Exception {
            UIViewSearchResult uiComp = (UIViewSearchResult)((Object)event.getSource());
            String downloadLink = uiComp.getDownloadLink(Utils.getFileLangNode((Node)uiComp.getNode()));
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
            event.getRequestContext().addUIComponentToUpdateByAjax(uiComp.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeLanguageActionListener
    extends EventListener<UIViewSearchResult> {
        public void execute(Event<UIViewSearchResult> event) throws Exception {
            UIViewSearchResult uiViewSearchResult = (UIViewSearchResult)((Object)event.getSource());
            String selectedLanguage = event.getRequestContext().getRequestParameter("objectId");
            uiViewSearchResult.setLanguage(selectedLanguage);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiViewSearchResult.getParent());
        }
    }
}

