/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.crypto;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.codec.Base64;
import org.jsecurity.codec.CodecSupport;
import org.jsecurity.crypto.Cipher;

public class BlowfishCipher
implements Cipher {
    private static final String ALGORITHM = "Blowfish";
    private static final String TRANSFORMATION_STRING = "Blowfish/ECB/PKCS5Padding";
    private static final byte[] KEY_BYTES = Base64.decode("jJ9Kg1BAevbvhSg3vBfwfQ==");
    private static final Key DEFAULT_CIPHER_KEY = new SecretKeySpec(KEY_BYTES, "Blowfish");
    private static final Log log = LogFactory.getLog(BlowfishCipher.class);
    private Key key = DEFAULT_CIPHER_KEY;

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public byte[] encrypt(byte[] raw, byte[] key) {
        byte[] encrypted = this.crypt(raw, 1, key);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Incoming byte array of size " + (raw != null ? raw.length : 0) + ".  Encrypted " + "byte array is size " + (encrypted != null ? encrypted.length : 0)));
        }
        return encrypted;
    }

    public byte[] decrypt(byte[] encrypted, byte[] key) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attempting to decrypt incoming byte array of length " + (encrypted != null ? encrypted.length : 0)));
        }
        return this.crypt(encrypted, 2, key);
    }

    protected javax.crypto.Cipher newCipherInstance() throws IllegalStateException {
        try {
            return javax.crypto.Cipher.getInstance(TRANSFORMATION_STRING);
        }
        catch (Exception e) {
            String msg = "Unable to acquire a Java JCE Cipher instance using " + javax.crypto.Cipher.class.getName() + ".getInstance( \"" + TRANSFORMATION_STRING + "\" ). " + "Blowfish under this configuration is required for the " + this.getClass().getName() + " instance to function.";
            throw new IllegalStateException(msg, e);
        }
    }

    protected void init(javax.crypto.Cipher cipher, int mode, Key key) {
        try {
            cipher.init(mode, key);
        }
        catch (InvalidKeyException e) {
            String msg = "Unable to init cipher.";
            throw new IllegalStateException(msg, e);
        }
    }

    protected byte[] crypt(javax.crypto.Cipher cipher, byte[] bytes) {
        try {
            return cipher.doFinal(bytes);
        }
        catch (Exception e) {
            String msg = "Unable to crypt bytes with cipher [" + cipher + "].";
            throw new IllegalStateException(msg, e);
        }
    }

    protected byte[] crypt(byte[] bytes, int mode, byte[] key) {
        javax.crypto.Cipher cipher = this.newCipherInstance();
        Key jdkKey = key == null ? this.getKey() : new SecretKeySpec(key, ALGORITHM);
        this.init(cipher, mode, jdkKey);
        return this.crypt(cipher, bytes);
    }

    public static Key generateNewKey() {
        return BlowfishCipher.generateNewKey(128);
    }

    public static Key generateNewKey(int keyBitSize) {
        KeyGenerator kg;
        try {
            kg = KeyGenerator.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "Unable to acquire Blowfish algorithm.  This is required to function.";
            throw new IllegalStateException(msg, e);
        }
        kg.init(keyBitSize);
        return kg.generateKey();
    }

    public static void main(String[] unused) throws Exception {
        String[] cleartext;
        BlowfishCipher cipher = new BlowfishCipher();
        for (String clear : cleartext = new String[]{"Hello, this is a test.", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."}) {
            byte[] cleartextBytes = CodecSupport.toBytes(clear);
            System.out.println("Clear text: [" + clear + "]");
            System.out.println("Clear text base64: [" + Base64.encodeToString(cleartextBytes) + "]");
            byte[] encrypted = cipher.encrypt(cleartextBytes, null);
            String encryptedBase64 = Base64.encodeToString(encrypted);
            System.out.println("Encrypted base64: [" + encryptedBase64 + "]");
            byte[] decrypted = cipher.decrypt(Base64.decode(encryptedBase64), null);
            String decryptedString = CodecSupport.toString(decrypted);
            System.out.println("Arrays equal? " + Arrays.equals(cleartextBytes, decrypted));
            System.out.println("Decrypted text: [" + decryptedString + "]");
            System.out.println("Decrypted text base64: [" + Base64.encodeToString(decrypted) + "]");
        }
    }
}

