/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.mgt;

import java.net.InetAddress;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.Authenticator;
import org.jsecurity.authc.InetAuthenticationToken;
import org.jsecurity.authc.LogoutAware;
import org.jsecurity.crypto.Cipher;
import org.jsecurity.mgt.SessionsSecurityManager;
import org.jsecurity.realm.Realm;
import org.jsecurity.session.InvalidSessionException;
import org.jsecurity.session.Session;
import org.jsecurity.subject.AbstractRememberMeManager;
import org.jsecurity.subject.DelegatingSubject;
import org.jsecurity.subject.PrincipalCollection;
import org.jsecurity.subject.RememberMeManager;
import org.jsecurity.subject.Subject;
import org.jsecurity.util.ThreadContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSecurityManager
extends SessionsSecurityManager {
    private static final Log log = LogFactory.getLog(DefaultSecurityManager.class);
    protected RememberMeManager rememberMeManager;

    public DefaultSecurityManager() {
    }

    public DefaultSecurityManager(Realm singleRealm) {
        this.setRealm(singleRealm);
    }

    public DefaultSecurityManager(Collection<Realm> realms) {
        this.setRealms(realms);
    }

    public RememberMeManager getRememberMeManager() {
        return this.rememberMeManager;
    }

    public void setRememberMeManager(RememberMeManager rememberMeManager) {
        this.rememberMeManager = rememberMeManager;
    }

    private AbstractRememberMeManager getRememberMeManagerForCipherAttributes() {
        RememberMeManager rmm = this.getRememberMeManager();
        if (!(rmm instanceof AbstractRememberMeManager)) {
            String msg = "The convenience passthrough methods for setting remember me cipher attributes are only available when the underlying RememberMeManager implementation is a subclass of " + AbstractRememberMeManager.class.getName() + ".";
            throw new IllegalStateException(msg);
        }
        return (AbstractRememberMeManager)rmm;
    }

    public void setRememberMeCipher(Cipher cipher) {
        this.getRememberMeManagerForCipherAttributes().setCipher(cipher);
    }

    public void setRememberMeCipherKey(byte[] bytes) {
        this.getRememberMeManagerForCipherAttributes().setCipherKey(bytes);
    }

    public void setRememberMeCipherKeyHex(String hex) {
        this.getRememberMeManagerForCipherAttributes().setCipherKeyHex(hex);
    }

    public void setRememberMeCipherKeyBase64(String base64) {
        this.getRememberMeManagerForCipherAttributes().setCipherKeyBase64(base64);
    }

    public void setRememberMeEncryptionCipherKey(byte[] bytes) {
        this.getRememberMeManagerForCipherAttributes().setEncryptionCipherKey(bytes);
    }

    public void setRememberMeEncryptionCipherKeyHex(String hex) {
        this.getRememberMeManagerForCipherAttributes().setEncryptionCipherKeyHex(hex);
    }

    public void setRememberMeEncryptionCipherKeyBase64(String base64) {
        this.getRememberMeManagerForCipherAttributes().setEncryptionCipherKeyBase64(base64);
    }

    public void setRememberMeDecryptionCipherKey(byte[] bytes) {
        this.getRememberMeManagerForCipherAttributes().setDecryptionCipherKey(bytes);
    }

    public void setRememberMeDecryptionCipherKeyHex(String hex) {
        this.getRememberMeManagerForCipherAttributes().setDecryptionCipherKeyHex(hex);
    }

    public void setRememberMeDecryptionCipherKeyBase64(String base64) {
        this.getRememberMeManagerForCipherAttributes().setDecryptionCipherKeyBase64(base64);
    }

    private void assertPrincipals(AuthenticationInfo info) {
        PrincipalCollection principals = info.getPrincipals();
        if (principals == null || principals.isEmpty()) {
            String msg = "Authentication info returned from Authenticator must have non null and non empty principals.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected Subject createSubject() {
        PrincipalCollection principals = this.getRememberedIdentity();
        return this.createSubject(principals);
    }

    protected Subject createSubject(PrincipalCollection subjectPrincipals) {
        return this.createSubject(subjectPrincipals, null);
    }

    protected Subject createSubject(PrincipalCollection principals, Session existing) {
        return this.createSubject(principals, existing, false);
    }

    protected Subject createSubject(PrincipalCollection principals, Session existing, boolean authenticated) {
        return this.createSubject(principals, existing, authenticated, null);
    }

    protected Subject createSubject(PrincipalCollection principals, Session existing, boolean authenticated, InetAddress inetAddress) {
        return new DelegatingSubject(principals, authenticated, inetAddress, existing, this);
    }

    protected Subject createSubject(AuthenticationToken token, AuthenticationInfo info) {
        this.assertPrincipals(info);
        Subject subject = this.getSubject(false);
        Session session = null;
        if (subject != null) {
            session = subject.getSession(false);
        }
        InetAddress authcSourceIP = null;
        if (token instanceof InetAuthenticationToken) {
            authcSourceIP = ((InetAuthenticationToken)token).getInetAddress();
        }
        if (authcSourceIP == null) {
            authcSourceIP = ThreadContext.getInetAddress();
        }
        return this.createSubject(info.getPrincipals(), session, true, authcSourceIP);
    }

    protected void bind(Subject subject) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Binding Subject [" + subject + "] to a thread local..."));
        }
        ThreadContext.bind(subject);
    }

    private void assertCreation(Subject subject) throws IllegalStateException {
        if (subject == null) {
            String msg = "Programming error - please verify that you have overridden the " + this.getClass().getName() + ".createSubject( AuthenticationInfo info ) method to return " + "a non-null Subject instance";
            throw new IllegalStateException(msg);
        }
    }

    protected void rememberMeSuccessfulLogin(AuthenticationToken token, AuthenticationInfo info) {
        RememberMeManager rmm = this.getRememberMeManager();
        if (rmm != null) {
            try {
                rmm.onSuccessfulLogin(token, info);
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    String msg = "Delegate RememberMeManager instance of type [" + rmm.getClass().getName() + "] threw an exception during onSuccessfulLogin.  RememberMe services will not be " + "performed for account [" + info + "].";
                    log.warn((Object)msg, (Throwable)e);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("This " + this.getClass().getName() + " instance does not have a " + "[" + RememberMeManager.class.getName() + "] instance configured.  RememberMe services " + "will not be performed for account [" + info + "]."));
        }
    }

    protected void rememberMeFailedLogin(AuthenticationToken token, AuthenticationException ex) {
        block3: {
            RememberMeManager rmm = this.getRememberMeManager();
            if (rmm != null) {
                try {
                    rmm.onFailedLogin(token, ex);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block3;
                    String msg = "Delegate RememberMeManager instance of type [" + rmm.getClass().getName() + "] threw an exception during onFailedLogin for AuthenticationToken [" + token + "].";
                    log.warn((Object)msg, (Throwable)e);
                }
            }
        }
    }

    protected void rememberMeLogout(PrincipalCollection subjectPrincipals) {
        block3: {
            RememberMeManager rmm = this.getRememberMeManager();
            if (rmm != null) {
                try {
                    rmm.onLogout(subjectPrincipals);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block3;
                    String msg = "Delegate RememberMeManager instance of type [" + rmm.getClass().getName() + "] threw an exception during onLogout for subject with principals [" + subjectPrincipals + "]";
                    log.warn((Object)msg, (Throwable)e);
                }
            }
        }
    }

    @Override
    public Subject login(AuthenticationToken token) throws AuthenticationException {
        AuthenticationInfo info;
        try {
            info = this.authenticate(token);
            this.onSuccessfulLogin(token, info);
        }
        catch (AuthenticationException ae) {
            block4: {
                try {
                    this.onFailedLogin(token, ae);
                }
                catch (Exception e) {
                    if (!log.isInfoEnabled()) break block4;
                    log.info((Object)"onFailedLogin(AuthenticationToken,AuthenticationException) method threw an exception.  Logging and propagating original AuthenticationException.", (Throwable)e);
                }
            }
            throw ae;
        }
        Subject subject = this.createSubject(token, info);
        this.assertCreation(subject);
        this.bind(subject);
        return subject;
    }

    protected void onSuccessfulLogin(AuthenticationToken token, AuthenticationInfo info) {
        this.rememberMeSuccessfulLogin(token, info);
    }

    protected void onFailedLogin(AuthenticationToken token, AuthenticationException ae) {
        this.rememberMeFailedLogin(token, ae);
    }

    protected void beforeLogout(PrincipalCollection subjectIdentifier) {
        this.rememberMeLogout(subjectIdentifier);
    }

    @Override
    public void logout(PrincipalCollection principals) {
        block8: {
            Subject subject;
            if (principals != null) {
                this.beforeLogout(principals);
                Authenticator authc = this.getAuthenticator();
                if (authc instanceof LogoutAware) {
                    ((LogoutAware)((Object)authc)).onLogout(principals);
                }
            }
            if ((subject = this.getSubject(false)) != null) {
                String msg;
                block7: {
                    try {
                        this.stopSession(subject);
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block7;
                        msg = "Unable to cleanly stop Session for Subject [" + subject.getPrincipal() + "] " + "Ignoring (logging out).";
                        log.debug((Object)msg, (Throwable)e);
                    }
                }
                try {
                    this.unbind(subject);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block8;
                    msg = "Unable to cleanly unbind Subject.  Ignoring (logging out).";
                    log.debug((Object)msg, (Throwable)e);
                }
            }
        }
    }

    protected void stopSession(Subject subject) {
        block3: {
            Session s = subject.getSession(false);
            if (s != null) {
                try {
                    s.stop();
                }
                catch (InvalidSessionException ise) {
                    if (!log.isTraceEnabled()) break block3;
                    log.trace((Object)("Session has already been invalidated for subject [" + subject.getPrincipal() + "].  Ignoring and continuing logout ..."), (Throwable)ise);
                }
            }
        }
    }

    protected void unbind(Subject subject) {
        ThreadContext.unbindSubject();
    }

    protected PrincipalCollection getRememberedIdentity() {
        block3: {
            RememberMeManager rmm = this.getRememberMeManager();
            if (rmm != null) {
                try {
                    return rmm.getRememberedPrincipals();
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block3;
                    String msg = "Delegate RememberMeManager instance of type [" + rmm.getClass().getName() + "] threw an exception during getRememberedPrincipals().";
                    log.warn((Object)msg, (Throwable)e);
                }
            }
        }
        return null;
    }

    protected Subject getSubject(boolean create) {
        Subject subject = ThreadContext.getSubject();
        if (subject == null && create) {
            subject = this.createSubject();
            this.bind(subject);
        }
        return subject;
    }

    @Override
    public Subject getSubject() {
        return this.getSubject(true);
    }
}

