/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.queries;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.queries.UIQueriesForm;
import org.exoplatform.ecm.webui.component.admin.queries.UIQueriesManager;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/queries/UIQueriesList.gtmpl", events={@EventConfig(listeners={AddQueryActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIQueriesList.msg.confirm-delete")})
public class UIQueriesList
extends UIComponentDecorator {
    public static final String[] ACTIONS = new String[]{"AddQuery"};
    public static final String ST_ADD = "AddQueryForm";
    public static final String ST_EDIT = "EditQueryForm";
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "QueriesListIterator");

    public UIQueriesList() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void updateQueriesGrid(int currentPage) throws Exception {
        ObjectPageList pageList = new ObjectPageList(this.getAllSharedQueries(), 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.uiPageIterator_.setCurrentPage(currentPage - 1);
        } else {
            this.uiPageIterator_.setCurrentPage(currentPage);
        }
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public boolean canEditNode(Node node) {
        SessionProvider sProvider = WCMCoreUtils.getUserSessionProvider();
        try {
            ManageableRepository manageableRepository = (ManageableRepository)node.getSession().getRepository();
            Session session = sProvider.getSession(node.getSession().getWorkspace().getName(), manageableRepository);
            session.checkPermission(node.getPath(), "set_property");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean canRemoveNode(Node node) {
        SessionProvider sProvider = WCMCoreUtils.getUserSessionProvider();
        try {
            ManageableRepository manageableRepository = (ManageableRepository)node.getSession().getRepository();
            Session session = sProvider.getSession(node.getSession().getWorkspace().getName(), manageableRepository);
            session.checkPermission(node.getPath(), "remove");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public List getQueryList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public List<Node> getAllSharedQueries() throws Exception {
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        List queries = queryService.getSharedQueries(repository, SessionProviderFactory.createSystemProvider());
        Collections.sort(queries, new QueryComparator());
        return queries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIQueriesList> {
        public void execute(Event<UIQueriesList> event) throws Exception {
            UIQueriesList uiQueriesList = (UIQueriesList)((Object)event.getSource());
            UIQueriesManager uiQueriesMan = (UIQueriesManager)((UIQueriesList)((Object)event.getSource())).getParent();
            String repository = ((UIECMAdminPortlet)uiQueriesMan.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            String userName = Util.getPortalRequestContext().getRemoteUser();
            String queryName = event.getRequestContext().getRequestParameter("objectId");
            QueryService queryService = (QueryService)((UIQueriesList)((Object)event.getSource())).getApplicationComponent(QueryService.class);
            queryService.removeQuery(queryName, userName, repository);
            ((UIQueriesList)((Object)event.getSource())).updateQueriesGrid(uiQueriesList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiQueriesMan);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIQueriesList> {
        public void execute(Event<UIQueriesList> event) throws Exception {
            UIQueriesManager uiQueriesMan = (UIQueriesManager)((UIQueriesList)((Object)event.getSource())).getParent();
            uiQueriesMan.removeChildById(UIQueriesList.ST_ADD);
            uiQueriesMan.initFormPopup(UIQueriesList.ST_EDIT);
            String queryPath = event.getRequestContext().getRequestParameter("objectId");
            UIQueriesForm uiForm = (UIQueriesForm)uiQueriesMan.findFirstComponentOfType(UIQueriesForm.class);
            String queryName = queryPath.substring(queryPath.lastIndexOf("/") + 1);
            uiForm.update(queryName);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiQueriesMan);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddQueryActionListener
    extends EventListener<UIQueriesList> {
        public void execute(Event<UIQueriesList> event) throws Exception {
            UIQueriesManager uiQueriesMan = (UIQueriesManager)((UIQueriesList)((Object)event.getSource())).getParent();
            uiQueriesMan.removeChildById(UIQueriesList.ST_EDIT);
            uiQueriesMan.initFormPopup(UIQueriesList.ST_ADD);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiQueriesMan);
        }
    }

    public static class QueryComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            try {
                String name1 = ((Node)o1).getName();
                String name2 = ((Node)o2).getName();
                return name1.compareToIgnoreCase(name2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

