/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContent;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTemplate;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIViewTab.msg.confirm-delete")})
public class UIViewTab
extends UIContainer {
    private static final String[] BEAN_FIELD = new String[]{"name", "roles", "baseVersion"};
    private static final String[] ACTIONS = new String[]{"Edit", "Delete"};
    public static final String VIEW_LIST_NAME = "VewList";
    public static final String VIEW_FORM_NAME = "ViewForm";
    private List<String> listView_ = new ArrayList<String>();

    public UIViewTab() throws Exception {
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, null, VIEW_LIST_NAME);
        uiGrid.getUIPageIterator().setId("ViewListIterator");
        uiGrid.configure("name", BEAN_FIELD, ACTIONS);
        UITemplateContent uiForm = (UITemplateContent)this.addChild(UITemplateContent.class, null, VIEW_FORM_NAME);
        uiForm.setTemplateType(TemplateService.VIEWS);
        uiForm.update(null);
    }

    public List<String> getListView() {
        return this.listView_;
    }

    public void updateGrid(String nodeName) throws Exception {
        TemplateService tempService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        NodeIterator iter = tempService.getAllTemplatesOfNodeType(false, nodeName, this.getRepository(), SessionProviderFactory.createSystemProvider());
        ArrayList<ViewData> data = new ArrayList<ViewData>();
        if (iter == null) {
            return;
        }
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            String version = "";
            StringBuilder rule = new StringBuilder();
            Value[] rules = node.getNode("jcr:content").getProperty("exo:roles").getValues();
            for (int i = 0; i < rules.length; ++i) {
                rule.append("[" + rules[i].getString() + "]");
            }
            if (node.isNodeType("mix:versionable") && !node.isNodeType(Utils.NT_FROZEN)) {
                version = node.getBaseVersion().getName();
            }
            this.listView_.add(node.getName());
            ViewData item = new ViewData(node.getName(), rule.toString(), version);
            data.add(item);
        }
        UIGrid uiGrid = (UIGrid)this.getChild(UIGrid.class);
        ObjectPageList objDPageList = new ObjectPageList(data, 4);
        uiGrid.getUIPageIterator().setPageList((PageList)objDPageList);
    }

    public void setTabRendered() {
        UIViewTemplate uiViewTemplate = (UIViewTemplate)this.getAncestorOfType(UIViewTemplate.class);
        uiViewTemplate.setRenderedChild(UIViewTab.class);
    }

    private String getRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return portletPref.getValue(Utils.REPOSITORY, "");
    }

    public static class ViewData {
        private String name;
        private String roles;
        private String baseVersion;

        public ViewData(String name, String roles, String version) {
            this.name = name;
            this.roles = roles;
            this.baseVersion = version;
        }

        public String getName() {
            return this.name;
        }

        public String getRoles() {
            return this.roles;
        }

        public String getBaseVersion() {
            return this.baseVersion;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIViewTab> {
        public void execute(Event<UIViewTab> event) throws Exception {
            UIViewTab viewTab = (UIViewTab)((Object)event.getSource());
            UIViewTemplate uiViewTemplate = (UIViewTemplate)((UIViewTab)((Object)event.getSource())).getAncestorOfType(UIViewTemplate.class);
            String nodeTypeName = uiViewTemplate.getNodeTypeName();
            String templateName = event.getRequestContext().getRequestParameter("objectId");
            TemplateService templateService = (TemplateService)viewTab.getApplicationComponent(TemplateService.class);
            for (String template : TemplateService.UNDELETABLE_TEMPLATES) {
                if (!template.equals(templateName)) continue;
                UIApplication app = (UIApplication)viewTab.getAncestorOfType(UIApplication.class);
                Object[] args = new Object[]{template};
                app.addMessage(new ApplicationMessage("UIViewTab.msg.undeletable", args));
                viewTab.setTabRendered();
                return;
            }
            templateService.removeTemplate(TemplateService.VIEWS, nodeTypeName, templateName, viewTab.getRepository());
            UITemplateContent uiForm = (UITemplateContent)viewTab.findFirstComponentOfType(UITemplateContent.class);
            uiForm.update(null);
            uiForm.reset();
            viewTab.updateGrid(nodeTypeName);
            viewTab.setTabRendered();
            UITemplatesManager uiManager = (UITemplatesManager)viewTab.getAncestorOfType(UITemplatesManager.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIViewTab> {
        public void execute(Event<UIViewTab> event) throws Exception {
            UIViewTab viewTab = (UIViewTab)((Object)event.getSource());
            String viewName = event.getRequestContext().getRequestParameter("objectId");
            UITemplateContent uiForm = (UITemplateContent)viewTab.getChild(UITemplateContent.class);
            uiForm.update(viewName);
            viewTab.setTabRendered();
            UITemplatesManager uiManager = (UITemplatesManager)viewTab.getAncestorOfType(UITemplatesManager.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

