/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.gatein.common.logging.LogLevel;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.query.UserQuery;
import org.picketlink.idm.api.query.UserQueryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDMUserListAccess
implements ListAccess<User> {
    private static Logger log = LoggerFactory.getLogger(IDMUserListAccess.class);
    private final UserDAOImpl userDAO;
    private final PicketLinkIDMService idmService;
    private final UserQueryBuilder userQueryBuilder;
    private final int pageSize;
    private final boolean countAll;

    public IDMUserListAccess(UserDAOImpl userDAO, PicketLinkIDMService idmService, UserQueryBuilder userQueryBuilder, int pageSize, boolean countAll) {
        this.userDAO = userDAO;
        this.idmService = idmService;
        this.userQueryBuilder = userQueryBuilder;
        this.pageSize = pageSize;
        this.countAll = countAll;
    }

    public User[] load(int index, int length) throws Exception, IllegalArgumentException {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "load", new Object[]{"index", index, "length", length});
        }
        this.userQueryBuilder.page(index, length);
        UserQuery query = this.userQueryBuilder.sort(SortOrder.ASCENDING).createQuery();
        List users = this.idmService.getIdentitySession().list(query);
        User[] exoUsers = new User[users.size()];
        for (int i = 0; i < users.size(); ++i) {
            org.picketlink.idm.api.User user = (org.picketlink.idm.api.User)users.get(i);
            exoUsers[i] = UserDAOImpl.getPopulatedUser(user.getId(), this.idmService.getIdentitySession());
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "load", exoUsers);
        }
        return exoUsers;
    }

    public int getSize() throws Exception {
        int result;
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "getSize", null);
        }
        if (this.countAll) {
            result = this.idmService.getIdentitySession().getPersistenceManager().getUserCount();
        } else {
            this.userQueryBuilder.page(0, 0);
            UserQuery query = this.userQueryBuilder.sort(SortOrder.ASCENDING).createQuery();
            result = this.idmService.getIdentitySession().execute(query).size();
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "getSize", result);
        }
        return result;
    }
}

