/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static InputStream scaleImage(BufferedImage image, int maxWidth, int maxHeight) throws Exception {
        double imageRatio;
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        if (maxWidth > 0 && imageWidth > maxWidth) {
            imageRatio = (double)maxWidth / (double)imageWidth;
            imageHeight = (int)((double)imageHeight * imageRatio);
            imageWidth = maxWidth;
        }
        if (maxHeight > 0 && imageHeight > maxHeight) {
            imageRatio = (double)maxHeight / (double)imageHeight;
            imageWidth = (int)((double)imageWidth * imageRatio);
            imageHeight = maxHeight;
        }
        BufferedImage thumbImage = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, imageWidth, imageHeight, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(thumbImage);
        int quality = 100;
        quality = Math.max(0, Math.min(quality, 100));
        param.setQuality((float)quality / 100.0f, false);
        encoder.setJPEGEncodeParam(param);
        encoder.encode(thumbImage);
        ImageIO.write((RenderedImage)thumbImage, "JPEG", out);
        ByteArrayInputStream bis = new ByteArrayInputStream(out.toByteArray());
        return bis;
    }
}

