/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core.impl;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="wcm"), @Property(key="type", value="content")})
@ManagedDescription(value="WCM Service")
@RESTEndpoint(path="wcmservice")
public class WCMServiceImpl
implements WCMService {
    int expirationCache;

    public WCMServiceImpl(InitParams initParams) throws Exception {
        PropertiesParam propertiesParam = initParams.getPropertiesParam("server.config");
        String expirationCache = propertiesParam.getProperty("expirationCache");
        this.setPortletExpirationCache(new Integer(expirationCache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getReferencedContent(SessionProvider sessionProvider, String repository, String workspace, String nodeIdentifier) throws Exception {
        if (repository == null || workspace == null || nodeIdentifier == null) {
            throw new ItemNotFoundException();
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        Node content = null;
        try {
            content = session.getNodeByUUID(nodeIdentifier);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            try {
                content = (Node)session.getItem(nodeIdentifier);
            }
            catch (Exception exception) {
                content = null;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return content;
    }

    public boolean isSharedPortal(SessionProvider sessionProvider, String portalName) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)container.getComponentInstanceOfType(LivePortalManagerService.class);
        boolean isShared = false;
        Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
        isShared = sharedPortal.getName().equals(portalName);
        return isShared;
    }

    @Managed
    @ManagedDescription(value="Sets the WCM Portlet Expiration cache (in seconds) ?")
    public void setPortletExpirationCache(@ManagedDescription(value="Change the WCM Portlet Expiration cache") @ManagedName(value="expirationCache") int expirationCache) throws Exception {
        this.expirationCache = expirationCache;
    }

    @Managed
    @ManagedDescription(value="What is the WCM Portlet Expiration cache (in seconds) ?")
    public int getPortletExpirationCache() throws Exception {
        return this.expirationCache;
    }
}

