/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.Calendar;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.ISO8601;

public class EventQuery {
    private String nodeType = "exo:calendarEvent";
    private String eventType;
    private String text = null;
    private String[] categoryIds = null;
    private String[] calendarIds = null;
    private String[] filterCalendarIds = null;
    private Calendar fromDate = null;
    private Calendar toDate = null;
    private String calendarPath;
    private String priority;
    private String state;
    private String[] orderBy;
    private String[] participants;
    private String orderType = "ascending";
    private String queryType = "xpath";
    private long limitedItems = 0L;

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nt) {
        this.nodeType = nt;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setText(String fullTextSearch) {
        this.text = fullTextSearch;
    }

    public String getText() {
        return this.text;
    }

    public String[] getCategoryId() {
        return this.categoryIds;
    }

    public void setCategoryId(String[] categoryIds) {
        this.categoryIds = categoryIds;
    }

    public String[] getCalendarId() {
        return this.calendarIds;
    }

    public void setCalendarId(String[] calendarIds) {
        this.calendarIds = calendarIds;
    }

    public void setFilterCalendarIds(String[] filterCalendarIds) {
        this.filterCalendarIds = filterCalendarIds;
    }

    public String[] getFilterCalendarIds() {
        return this.filterCalendarIds;
    }

    public Calendar getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Calendar fromDate) {
        this.fromDate = fromDate;
    }

    public Calendar getToDate() {
        return this.toDate;
    }

    public void setToDate(Calendar toDate) {
        this.toDate = toDate;
    }

    public String getCalendarPath() {
        return this.calendarPath;
    }

    public void setCalendarPath(String calendarPath) {
        this.calendarPath = calendarPath;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String st) {
        this.state = st;
    }

    public String[] getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String[] order) {
        this.orderBy = order;
    }

    public String[] getParticipants() {
        return this.participants;
    }

    public void setParticipants(String[] par) {
        this.participants = par;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String type) {
        this.orderType = type;
    }

    public String getQueryStatement() throws Exception {
        int i;
        StringBuffer queryString = null;
        if (this.queryType.equals("sql")) {
            queryString = !Utils.isEmpty(this.calendarPath) ? new StringBuffer(" select * from " + this.nodeType + " where jcr:path like '" + this.calendarPath + "/%'") : new StringBuffer(" select * from " + this.nodeType + " ");
            if (!Utils.isEmpty(this.text)) {
                this.text.replaceAll("\"", "\\\"").replaceAll("-", "");
                queryString.append(" and (" + Utils.EXO_SUMMARY + " like '%" + this.text + "%'");
                queryString.append(" or " + Utils.EXO_DESCRIPTION + " like '%" + this.text + "%'");
                queryString.append(" or " + Utils.EXO_LOCATION + " like '%" + this.text + "%'");
                queryString.append(" or " + Utils.EXO_PARTICIPANT + " like '%" + this.text + "%'");
                queryString.append(" or " + Utils.EXO_INVITATION + " like '%" + this.text + "%'");
                queryString.append(")");
            }
            if (!Utils.isEmpty(this.eventType)) {
                queryString.append(" and " + Utils.EXO_EVENT_TYPE + " = '" + this.eventType + "'");
            }
            if (!Utils.isEmpty(this.priority)) {
                queryString.append(" and " + Utils.EXO_PRIORITY + " = '" + this.priority + "'");
            }
            if (!Utils.isEmpty(this.state)) {
                queryString.append(" and " + Utils.EXO_EVENT_STATE + " = '" + this.state + "'");
            }
            if (this.categoryIds != null && this.categoryIds.length > 0) {
                for (String category : this.categoryIds) {
                    queryString.append(" and " + Utils.EXO_EVENT_CATEGORYID + " = '" + category + "'");
                }
            }
            if (this.calendarIds != null && this.calendarIds.length > 0) {
                for (String calendarId : this.calendarIds) {
                    queryString.append(" and " + Utils.EXO_CALENDAR_ID + " = '" + calendarId + "'");
                }
            }
            return queryString.toString();
        }
        queryString = this.calendarPath != null ? new StringBuffer("/jcr:root" + this.calendarPath + "//element(*," + this.nodeType + ")") : new StringBuffer("/jcr:root//element(*," + this.nodeType + ")");
        boolean hasConjuntion = false;
        StringBuffer stringBuffer = new StringBuffer("[");
        if (this.text != null && this.text.length() > 0) {
            stringBuffer.append("jcr:contains(., '").append(this.text).append("')");
            hasConjuntion = true;
        }
        if (this.eventType != null && this.eventType.length() > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:eventType='" + this.eventType + "'");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.priority != null && this.priority.length() > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:priority='" + this.priority + "'");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.state != null && this.state.length() > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:eventState='" + this.state + "'");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.categoryIds != null && this.categoryIds.length > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            for (i = 0; i < this.categoryIds.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:eventCategoryId='" + this.categoryIds[i] + "'");
                    continue;
                }
                stringBuffer.append(" or @exo:eventCategoryId='" + this.categoryIds[i] + "'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.calendarIds != null && this.calendarIds.length > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            for (i = 0; i < this.calendarIds.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:calendarId='" + this.calendarIds[i] + "'");
                    continue;
                }
                stringBuffer.append(" or @exo:calendarId='" + this.calendarIds[i] + "'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.filterCalendarIds != null && this.filterCalendarIds.length > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            for (i = 0; i < this.filterCalendarIds.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:calendarId !='" + this.filterCalendarIds[i] + "'");
                    continue;
                }
                stringBuffer.append(" and @exo:calendarId !='" + this.filterCalendarIds[i] + "'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.participants != null && this.participants.length > 0) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            for (i = 0; i < this.participants.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("@exo:participant='" + this.participants[i] + "'");
                    continue;
                }
                stringBuffer.append(" or @exo:participant='" + this.participants[i] + "'");
            }
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        if (this.fromDate != null && this.toDate != null) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("(");
            stringBuffer.append("@exo:fromDateTime <= xs:dateTime('" + ISO8601.format((Calendar)this.fromDate) + "') and ");
            stringBuffer.append("@exo:toDateTime >= xs:dateTime('" + ISO8601.format((Calendar)this.toDate) + "')");
            stringBuffer.append(") or (");
            stringBuffer.append("@exo:fromDateTime >= xs:dateTime('" + ISO8601.format((Calendar)this.fromDate) + "') and ");
            stringBuffer.append("@exo:fromDateTime <= xs:dateTime('" + ISO8601.format((Calendar)this.toDate) + "')");
            stringBuffer.append(") or (");
            stringBuffer.append("@exo:toDateTime >= xs:dateTime('" + ISO8601.format((Calendar)this.fromDate) + "') and ");
            stringBuffer.append("@exo:toDateTime <= xs:dateTime('" + ISO8601.format((Calendar)this.toDate) + "')");
            stringBuffer.append(")");
            stringBuffer.append(")");
            hasConjuntion = true;
        } else if (this.fromDate != null) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:fromDateTime >= xs:dateTime('" + ISO8601.format((Calendar)this.fromDate) + "')");
            stringBuffer.append(")");
            hasConjuntion = true;
        } else if (this.toDate != null) {
            if (hasConjuntion) {
                stringBuffer.append(" and (");
            } else {
                stringBuffer.append("(");
            }
            stringBuffer.append("@exo:toDateTime <= xs:dateTime('" + ISO8601.format((Calendar)this.toDate) + "')");
            stringBuffer.append(")");
            hasConjuntion = true;
        }
        stringBuffer.append("]");
        if (this.orderBy != null && this.orderBy.length > 0 && this.orderType != null && this.orderType.length() > 0) {
            for (i = 0; i < this.orderBy.length; ++i) {
                if (i == 0) {
                    stringBuffer.append(" order by @" + this.orderBy[i].trim() + " " + this.orderType);
                    continue;
                }
                stringBuffer.append(", order by @" + this.orderBy[i].trim() + " " + this.orderType);
            }
            hasConjuntion = true;
        }
        if (hasConjuntion) {
            queryString.append(stringBuffer.toString());
        }
        return queryString.toString();
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setLimitedItems(int limitedItems) {
        this.limitedItems = limitedItems;
    }

    public void setLimitedItems(long limitedItems) {
        this.limitedItems = limitedItems;
    }

    public long getLimitedItems() {
        return this.limitedItems;
    }
}

