/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.transform.impl.html;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.services.xml.transform.NotSupportedIOTypeException;
import org.exoplatform.services.xml.transform.html.HTMLTransformer;
import org.exoplatform.services.xml.transform.impl.EncodingMapImpl;
import org.exoplatform.services.xml.transform.impl.TransformerBase;
import org.w3c.tidy.Tidy;

public class TidyTransformerImpl
extends TransformerBase
implements HTMLTransformer {
    protected Tidy tidy = new Tidy();
    protected Properties props;

    public TidyTransformerImpl() {
        this.initProps();
    }

    public Properties getOutputProperties() {
        return this.props;
    }

    public void setOutputProperties(Properties props) {
        this.props = props;
    }

    private void initProps() {
        this.props = new Properties();
        this.props.setProperty("quiet", "true");
        this.props.setProperty("quote-ampersand", "true");
        this.props.setProperty("output-xhtml", "true");
        this.props.setProperty("show-warnings", "false");
        this.props.setProperty("clean", "true");
        this.props.setProperty("add-xml-decl", "true");
        this.props.setProperty("char-encoding", "raw");
        this.props.setProperty("doctype", "omit");
        this.props.setProperty("tidy-mark", "no");
    }

    public void processNotNativeResult(ByteArrayInputStream byteInputStream) throws TransformerException {
        this.transformInputStream2Result(byteInputStream, this.getResult());
        this.log.debug((Object)("Transform from temp output to " + this.getResult().getClass().getName() + " complete"));
    }

    protected void internalTransform(Source source) throws NotSupportedIOTypeException, TransformerException, IllegalStateException {
        InputStream input = this.sourceAsInputStream(source);
        try {
            this.log.debug((Object)(" input available bytes " + input.available()));
            if (input.available() == 0) {
                return;
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"Error on read Source", (Throwable)ex);
            new TransformerException("Error on read source", ex);
        }
        this.tidy.setConfigurationFromProps(this.props);
        if (this.getResult() instanceof StreamResult) {
            OutputStream output = ((StreamResult)this.getResult()).getOutputStream();
            this.log.debug((Object)"Prepare to write transform result direct to OutputStream");
            this.tidy.parse(input, output);
            this.log.debug((Object)"Tidy parse is complete");
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.log.debug((Object)"Prepare to write transform result to temp output");
            this.tidy.parse(input, (OutputStream)output);
            this.log.debug((Object)"Tidy parse is complete");
            String outputString = output.toString();
            try {
                outputString = outputString.replaceFirst("<\\?xml version=\"1.0\"\\?>", "<?xml version=\"1.0\" encoding=\"" + this.getCurrentIANAEncoding() + "\"?>");
                output.flush();
            }
            catch (IOException ex) {
                throw new TransformerException(ex);
            }
            this.processNotNativeResult(new ByteArrayInputStream(outputString.getBytes()));
        }
    }

    protected String getCurrentIANAEncoding() throws UnsupportedEncodingException {
        EncodingMapImpl encodingMap = new EncodingMapImpl();
        String ianaEncoding = encodingMap.convertJava2IANA(System.getProperty("file.encoding"));
        if (ianaEncoding == null) {
            throw new UnsupportedEncodingException("Can't find corresponding type of encoding for : " + System.getProperty("file.encoding"));
        }
        return encodingMap.convertJava2IANA(ianaEncoding);
    }
}

